/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.owasp.dependencycheck.gradle.DependencyCheckPlugin;
import org.owasp.dependencycheck.gradle.extension.DependencyCheckExtension;

public class RewriteDependencyCheckPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(DependencyCheckPlugin.class);
        float failBuildOnCVSS = Float.parseFloat(System.getenv("FAIL_BUILD_ON_CVSS") != null ? System.getenv("FAIL_BUILD_ON_CVSS") : "9");
        String format = System.getenv("DEPENDENCY_CHECK_FORMAT") != null ? System.getenv("DEPENDENCY_CHECK_FORMAT") : "HTML";
        this.generateSuppressionsFile(project);
        project.getExtensions().configure(DependencyCheckExtension.class, ext -> {
            ext.getAnalyzers().setAssemblyEnabled(Boolean.valueOf(false));
            ext.getAnalyzers().setNodeAuditEnabled(Boolean.valueOf(false));
            ext.getAnalyzers().setNodeEnabled(Boolean.valueOf(false));
            ext.getAnalyzers().getRetirejs().setEnabled(Boolean.valueOf(false));
            ext.getFailBuildOnCVSS().set((Object)Float.valueOf(failBuildOnCVSS));
            ext.getFormat().set((Object)format);
            ext.getNvd().getApiKey().set((Object)System.getenv("NVD_API_KEY"));
            ext.getAnalyzers().setCentralEnabled(Boolean.valueOf(System.getenv("CENTRAL_ANALYZER_ENABLED")));
            ext.getAnalyzers().getOssIndex().setUsername(System.getenv("OSSINDEX_USERNAME"));
            ext.getAnalyzers().getOssIndex().setPassword(System.getenv("OSSINDEX_PASSWORD"));
        });
    }

    private void generateSuppressionsFile(Project project) {
        File projectSuppressionsFile;
        File sharedSuppressionsFile;
        block10: {
            File buildDir = ((Directory)project.getLayout().getBuildDirectory().get()).getAsFile();
            if (!buildDir.exists()) {
                project.getLogger().info("Creating build directory: {}", (Object)buildDir.getAbsolutePath());
                buildDir.mkdirs();
            }
            sharedSuppressionsFile = new File(buildDir, "suppressions.xml");
            projectSuppressionsFile = new File(project.getProjectDir(), "suppressions.xml");
            try (InputStream inputStream = this.getClass().getResourceAsStream("/suppressions.xml");){
                if (inputStream != null) {
                    Files.copy(inputStream, sharedSuppressionsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break block10;
                }
                throw new FileNotFoundException("Resource suppressions.xml not found");
            }
            catch (IOException e) {
                project.getLogger().error("Failed to copy suppressions.xml", (Throwable)e);
                throw new UncheckedIOException("Failed to copy suppressions.xml", e);
            }
        }
        project.getExtensions().configure(DependencyCheckExtension.class, ext -> {
            ArrayList<String> suppressionFiles = new ArrayList<String>();
            suppressionFiles.add(sharedSuppressionsFile.getAbsolutePath());
            project.getLogger().info("Adding shared suppressions file: {}", (Object)sharedSuppressionsFile.getAbsolutePath());
            if (projectSuppressionsFile.exists()) {
                project.getLogger().info("Adding project suppressions file: {}", (Object)projectSuppressionsFile.getAbsolutePath());
                suppressionFiles.add(projectSuppressionsFile.getAbsolutePath());
            }
            ext.setSuppressionFiles(suppressionFiles);
        });
    }
}

