/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class RecipeDependenciesExtension {
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final Map<String, Set<String>> dependenciesBySourceSet = new HashMap<String, Set<String>>();

    @Inject
    public RecipeDependenciesExtension(ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler) {
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
    }

    public void parserClasspath(String dependencyNotation) {
        this.addDependencyForSourceSet("main", dependencyNotation);
    }

    public void testParserClasspath(String dependencyNotation) {
        this.addDependencyForSourceSet("test", dependencyNotation);
    }

    public void parserClasspath(String sourceSetName, String dependencyNotation) {
        this.addDependencyForSourceSet(sourceSetName, dependencyNotation);
    }

    void addDependencyForSourceSet(String sourceSetName, String dependencyNotation) {
        this.dependenciesBySourceSet.computeIfAbsent(sourceSetName, k -> new HashSet()).add(dependencyNotation);
    }

    Map<Dependency, File> getResolved() {
        return this.getResolvedForSourceSet("main");
    }

    Map<Dependency, File> getResolvedForSourceSet(String sourceSetName) {
        HashMap<Dependency, File> resolved = new HashMap<Dependency, File>();
        Set<String> dependencies = this.dependenciesBySourceSet.get(sourceSetName);
        if (dependencies == null) {
            return resolved;
        }
        for (String dependencyNotation : dependencies) {
            Dependency dependency = this.dependencyHandler.create((Object)dependencyNotation);
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw new IllegalArgumentException("Only external module dependencies are supported as recipe dependencies.");
            }
            ((ExternalModuleDependency)dependency).setTransitive(false);
            for (File file : this.configurationContainer.detachedConfiguration(new Dependency[]{dependency}).resolve()) {
                resolved.put(dependency, file);
            }
        }
        return resolved;
    }
}

