/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Map;
import nebula.plugin.publishing.maven.MavenBasePublishPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.jvm.tasks.Jar;

public class ModerneSourceAvailableLicensePlugin
implements Plugin<Project> {
    private static final String LICENSE_NAME = "Moderne Source Available License";
    private static final String LICENSE_URL = "https://docs.moderne.io/licensing/moderne-source-available-license";

    public void apply(Project project) {
        project.getPlugins().apply(MavenBasePublishPlugin.class);
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishing.publications(publications -> publications.withType(MavenPublication.class, this::configureLicense));
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes(Map.of("License-Name", LICENSE_NAME, "License-Url", LICENSE_URL)));
    }

    private void configureLicense(MavenPublication publication) {
        publication.pom(pom -> pom.licenses(licenses -> {
            ((DefaultMavenPom)licenses).getLicenses().clear();
            licenses.license(license -> {
                license.getName().set((Object)LICENSE_NAME);
                license.getUrl().set((Object)LICENSE_URL);
            });
        }));
    }
}

