/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusPublishPlugin;
import java.net.URI;
import nebula.plugin.release.NetflixOssStrategies;
import nebula.plugin.release.ReleasePlugin;
import nebula.plugin.release.git.base.ReleasePluginExtension;
import nebula.plugin.release.git.base.VersionStrategy;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class RewriteRootProjectPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(ReleasePlugin.class);
        project.getPlugins().apply(NexusPublishPlugin.class);
        project.getExtensions().configure(NexusPublishExtension.class, ext -> ext.getRepositories().sonatype(nexusRepository -> {
            nexusRepository.getNexusUrl().set((Object)URI.create("https://ossrh-staging-api.central.sonatype.com/service/local/"));
            nexusRepository.getSnapshotRepositoryUrl().set((Object)URI.create("https://central.sonatype.com/repository/maven-snapshots/"));
        }));
        if (project.getExtensions().findByType(ReleasePluginExtension.class) != null) {
            project.getExtensions().configure(ReleasePluginExtension.class, ext -> ext.setDefaultVersionStrategy((VersionStrategy)NetflixOssStrategies.SNAPSHOT((Project)project)));
        }
        project.defaultTasks(new String[]{"build"});
    }
}

