/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import org.eclipse.jgit.util.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.openrewrite.gradle.RewriteRecipeAuthorAttributionTask;

public class RewriteRecipeAuthorAttributionPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (!new File(project.getRootDir(), ".git").exists()) {
            return;
        }
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (java == null) {
            return;
        }
        SourceSet mainSource = (SourceSet)java.getSourceSets().getByName("main");
        TaskContainer tasks = project.getTasks();
        TaskProvider copyAttribution = tasks.register("copyAttribution", Copy.class);
        tasks.named("processResources", ProcessResources.class).configure(task -> task.dependsOn(new Object[]{copyAttribution}));
        for (File sourceDir : mainSource.getAllSource().getSrcDirs()) {
            TaskProvider attr = tasks.register("rewriteRecipeAuthorAttribution" + StringUtils.capitalize((String)sourceDir.getName()), RewriteRecipeAuthorAttributionTask.class, task -> {
                task.dependsOn(new Object[]{mainSource.getCompileJavaTaskName()});
                task.setSources(sourceDir);
                task.setClasspath(mainSource.getOutput().getClassesDirs());
            });
            copyAttribution.configure(task -> {
                task.dependsOn(new Object[]{attr});
                task.from(new Object[]{((RewriteRecipeAuthorAttributionTask)((Object)((Object)attr.get()))).getOutputDirectory()});
                task.into((Object)new File(project.getBuildDir(), "resources/main/META-INF/rewrite/attribution"));
            });
        }
    }
}

