/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.concurrent.TimeUnit;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.openrewrite.gradle.RewriteDependencyCheckPlugin;
import org.openrewrite.gradle.RewriteJavaExtension;

public class RewriteJavaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(RewriteDependencyCheckPlugin.class);
        RewriteJavaExtension ext = (RewriteJavaExtension)project.getExtensions().create("rewriteJava", RewriteJavaExtension.class, new Object[0]);
        ext.getJacksonVersion().convention((Object)"2.17.2");
        project.getPlugins().apply(JavaLibraryPlugin.class);
        project.getConfigurations().all(config -> {
            config.getResolutionStrategy().cacheChangingModulesFor(0, TimeUnit.SECONDS);
            config.getResolutionStrategy().cacheDynamicVersionsFor(0, TimeUnit.SECONDS);
        });
        project.getExtensions().configure(JavaPluginExtension.class, java -> java.toolchain(toolchain -> toolchain.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)21))));
        project.getConfigurations().all(config -> config.resolutionStrategy(strategy -> strategy.cacheDynamicVersionsFor(0, "seconds")));
        RewriteJavaPlugin.addDependencies(project, ext);
        RewriteJavaPlugin.configureJavaCompile(project);
        RewriteJavaPlugin.configureTesting(project);
        project.getTasks().withType(Javadoc.class).configureEach(task -> task.options(opt -> {
            ((CoreJavadocOptions)opt).addStringOption("Xdoclint:none", "-quiet");
            opt.encoding("UTF-8");
        }));
        project.getTasks().withType(Jar.class).configureEach(task -> task.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE));
    }

    private static void addDependencies(Project project, RewriteJavaExtension ext) {
        DependencyHandler deps = project.getDependencies();
        deps.add("compileOnly", (Object)"org.projectlombok:lombok:latest.release");
        deps.add("testCompileOnly", (Object)"org.projectlombok:lombok:latest.release");
        deps.add("annotationProcessor", (Object)"org.projectlombok:lombok:latest.release");
        deps.add("testAnnotationProcessor", (Object)"org.projectlombok:lombok:latest.release");
        deps.add("api", (Object)deps.platform((Object)("com.fasterxml.jackson:jackson-bom:" + (String)ext.getJacksonVersion().get())));
        deps.add("implementation", (Object)"org.jetbrains:annotations:latest.release");
        deps.add("compileOnly", (Object)"com.google.code.findbugs:jsr305:latest.release");
        deps.add("testImplementation", (Object)deps.platform((Object)"org.junit:junit-bom:5.+"));
        deps.add("testImplementation", (Object)"org.junit.jupiter:junit-jupiter-api");
        deps.add("testImplementation", (Object)"org.junit.jupiter:junit-jupiter-params");
        deps.add("testRuntimeOnly", (Object)"org.junit.jupiter:junit-jupiter-engine");
        deps.add("testImplementation", (Object)"org.assertj:assertj-core:latest.release");
    }

    private static void configureJavaCompile(Project project) {
        project.getTasks().named("compileJava", JavaCompile.class, task -> task.getOptions().getRelease().set((Object)8));
        project.getTasks().withType(JavaCompile.class).configureEach(task -> {
            task.getOptions().setEncoding("UTF-8");
            task.getOptions().getCompilerArgs().add("-parameters");
            task.getOptions().setFork(true);
        });
    }

    private static void configureTesting(Project project) {
        project.getTasks().withType(Test.class).configureEach(task -> {
            if (System.getenv("CI") == null) {
                task.setMaxParallelForks(Runtime.getRuntime().availableProcessors() / 2 > 0 ? Runtime.getRuntime().availableProcessors() / 2 : 1);
            } else {
                task.setMaxParallelForks(Runtime.getRuntime().availableProcessors());
            }
            task.useJUnitPlatform(junit -> junit.excludeTags(new String[]{"debug"}));
            task.jvmArgs(new Object[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+ShowHiddenFrames"});
            TestLoggingContainer log = task.getTestLogging();
            log.setShowExceptions(true);
            log.setExceptionFormat(TestExceptionFormat.FULL);
            log.setShowCauses(true);
            log.setShowStackTraces(true);
        });
    }
}

