/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

public class ExpectedExceptionToAssertThrows
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 `ExpectedException` To JUnit Jupiter's `assertThrows()`";
    }

    public String getDescription() {
        return "Replace usages of JUnit 4's `@Rule ExpectedException` with JUnit 5's `Assertions.assertThrows()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.rules.ExpectedException", Boolean.valueOf(false)), (TreeVisitor)new ExpectedExceptionToAssertThrowsVisitor());
    }

    public static class ExpectedExceptionToAssertThrowsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaParser.Builder<?, ?> javaParser;

        private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
            if (this.javaParser == null) {
                this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "hamcrest-3"});
            }
            return this.javaParser;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                if (statement instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)statement).getTypeExpression().getType(), (String)"org.junit.rules.ExpectedException")) {
                    this.maybeRemoveImport("org.junit.Rule");
                    this.maybeRemoveImport("org.junit.rules.ExpectedException");
                    return null;
                }
                return statement;
            })));
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(methodDecl, (Object)ctx);
            J.MethodInvocation expectMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectedExceptionMethodInvocation");
            J.MethodInvocation expectMessageMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectedExceptionMethodMessageInvocation");
            J.MethodInvocation expectCauseMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectCauseMethodInvocation");
            if (expectMethodInvocation == null && expectMessageMethodInvocation == null && expectCauseMethodInvocation == null) {
                return m;
            }
            assert (m.getBody() != null);
            J.Block bodyWithoutExpectedExceptionCalls = m.getBody().withStatements(ListUtils.map((List)m.getBody().getStatements(), statement -> ExpectedExceptionToAssertThrowsVisitor.isExpectedExceptionMethodInvocation(statement) ? null : statement));
            boolean isExpectArgAMatcher = false;
            if (expectMethodInvocation != null) {
                List args = expectMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectMethodArg = (Expression)args.get(0);
                isExpectArgAMatcher = this.isHamcrestMatcher((J)expectMethodArg);
                JavaType.FullyQualified argType = TypeUtils.asFullyQualified((JavaType)expectMethodArg.getType());
                if (!(isExpectArgAMatcher || argType != null && "java.lang.Class".equals(argType.getFullyQualifiedName()))) {
                    return m;
                }
            }
            boolean isExpectMessageArgAMatcher = false;
            if (expectMessageMethodInvocation != null) {
                List args = expectMessageMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectMessageMethodArg = (Expression)args.get(0);
                isExpectMessageArgAMatcher = this.isHamcrestMatcher((J)expectMessageMethodArg);
                if (!isExpectMessageArgAMatcher && !TypeUtils.isString((JavaType)expectMessageMethodArg.getType())) {
                    return m;
                }
            }
            boolean isExpectedCauseArgAMatcher = false;
            if (expectCauseMethodInvocation != null) {
                List args = expectCauseMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectCauseMethodArg = (Expression)args.get(0);
                isExpectedCauseArgAMatcher = this.isHamcrestMatcher((J)expectCauseMethodArg);
                if (!isExpectedCauseArgAMatcher) {
                    return m;
                }
            }
            String exceptionDeclParam = isExpectArgAMatcher || isExpectMessageArgAMatcher || isExpectedCauseArgAMatcher || expectMessageMethodInvocation != null ? "Throwable exception = " : "";
            String expectedExceptionParam = expectMethodInvocation == null || isExpectArgAMatcher ? "Exception.class" : expectMethodInvocation.getArguments().get(0);
            String templateString = expectedExceptionParam instanceof String ? "#{}assertThrows(#{}, () -> #{any()});" : "#{}assertThrows(#{any()}, () -> #{any()});";
            m = (J.MethodDeclaration)JavaTemplate.builder((String)templateString).contextSensitive().javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertThrows"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceBody(), new Object[]{exceptionDeclParam, expectedExceptionParam, bodyWithoutExpectedExceptionCalls});
            List thrown = m.getThrows();
            if (thrown != null && !thrown.isEmpty()) {
                assert (m.getBody() != null);
                m = m.withBody(m.getBody().withPrefix(((NameTree)thrown.get(0)).getPrefix())).withThrows(Collections.emptyList());
            }
            this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertThrows", false);
            if (expectMessageMethodInvocation != null && !isExpectMessageArgAMatcher && m.getBody() != null) {
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"assertTrue(exception.getMessage().contains(#{any(java.lang.String)}));").contextSensitive().javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertTrue"}).build().apply(this.updateCursor((Tree)m), m.getBody().getCoordinates().lastStatement(), new Object[]{expectMessageMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertTrue");
            }
            JavaTemplate assertThatTemplate = JavaTemplate.builder((String)"assertThat(#{}, #{any()});").contextSensitive().javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.hamcrest.MatcherAssert.assertThat"}).build();
            assert (m.getBody() != null);
            if (isExpectArgAMatcher) {
                m = (J.MethodDeclaration)assertThatTemplate.apply(this.updateCursor((Tree)m), m.getBody().getCoordinates().lastStatement(), new Object[]{"exception", expectMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            assert (m.getBody() != null);
            if (isExpectMessageArgAMatcher) {
                m = (J.MethodDeclaration)assertThatTemplate.apply(this.updateCursor((Tree)m), m.getBody().getCoordinates().lastStatement(), new Object[]{"exception.getMessage()", expectMessageMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            assert (m.getBody() != null);
            if (isExpectedCauseArgAMatcher) {
                m = (J.MethodDeclaration)assertThatTemplate.apply(this.updateCursor((Tree)m), m.getBody().getCoordinates().lastStatement(), new Object[]{"exception.getCause()", expectCauseMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            this.doAfterVisit(new LambdaBlockToExpression().getVisitor());
            return m;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null && "org.junit.rules.ExpectedException".equals(method.getMethodType().getDeclaringType().getFullyQualifiedName())) {
                switch (method.getSimpleName()) {
                    case "expect": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectedExceptionMethodInvocation", (Object)method);
                        break;
                    }
                    case "expectMessage": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectedExceptionMethodMessageInvocation", (Object)method);
                        break;
                    }
                    case "expectCause": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectCauseMethodInvocation", (Object)method);
                    }
                }
            }
            return method;
        }

        private boolean isHamcrestMatcher(J j) {
            if (!(j instanceof J.MethodInvocation)) {
                return false;
            }
            J.MethodInvocation method = (J.MethodInvocation)j;
            return method.getArguments().size() == 1 && method.getMethodType() != null && TypeUtils.isOfClassType((JavaType)method.getMethodType().getDeclaringType(), (String)"org.hamcrest.Matchers");
        }

        private static boolean isExpectedExceptionMethodInvocation(Statement statement) {
            if (!(statement instanceof J.MethodInvocation)) {
                return false;
            }
            J.MethodInvocation m = (J.MethodInvocation)statement;
            if (m.getMethodType() == null) {
                return false;
            }
            return TypeUtils.isOfClassType((JavaType)m.getMethodType().getDeclaringType(), (String)"org.junit.rules.ExpectedException");
        }
    }
}

