/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class SimplifyChainedAssertJAssertion
extends Recipe {
    @Option(displayName="AssertJ chained assertion", description="The chained AssertJ assertion to move to dedicated assertion.", example="equals", required=false)
    @Nullable String chainedAssertion;
    @Option(displayName="AssertJ replaced assertion", description="The AssertJ assert that should be replaced.", example="isTrue", required=false)
    @Nullable String assertToReplace;
    @Option(displayName="AssertJ replacement assertion", description="The AssertJ method to migrate to.", example="isEqualTo", required=false)
    @Nullable String dedicatedAssertion;
    @Option(displayName="Required type", description="The type of the actual assertion argument.", example="java.lang.String", required=false)
    @Nullable String requiredType;

    public String getDisplayName() {
        return "Simplify AssertJ chained assertions";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S5838");
    }

    public String getDescription() {
        return "Many AssertJ chained assertions have dedicated assertions that function the same. It is best to use the dedicated assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher assertThatMatcher = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
        final MethodMatcher chainedAssertMatcher = new MethodMatcher("java..* " + this.chainedAssertion + "(..)");
        final MethodMatcher assertToReplace = new MethodMatcher("org.assertj.core.api.* " + this.assertToReplace + "(..)");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                J.MethodInvocation actual;
                J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if (!assertToReplace.matches((MethodCall)mi) || mi.getArguments().size() != 1) {
                    return mi;
                }
                J.MethodInvocation assertThat = (J.MethodInvocation)mi.getSelect();
                if (!assertThatMatcher.matches((MethodCall)assertThat) || !(assertThat.getArguments().get(0) instanceof J.MethodInvocation)) {
                    return mi;
                }
                J.MethodInvocation assertThatArg = (J.MethodInvocation)assertThat.getArguments().get(0);
                if (!chainedAssertMatcher.matches((MethodCall)assertThatArg)) {
                    return mi;
                }
                Object object = actual = assertThatArg.getSelect() != null ? assertThatArg.getSelect() : assertThatArg;
                if (!TypeUtils.isAssignableTo((String)SimplifyChainedAssertJAssertion.this.requiredType, (JavaType)actual.getType())) {
                    return mi;
                }
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                arguments.add((Expression)actual);
                String template = this.getStringTemplateAndAppendArguments(assertThatArg, mi, arguments);
                return (J.MethodInvocation)JavaTemplate.builder((String)String.format(template, SimplifyChainedAssertJAssertion.this.dedicatedAssertion)).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), arguments.toArray());
            }

            private String getStringTemplateAndAppendArguments(J.MethodInvocation assertThatArg, J.MethodInvocation methodToReplace, List<Expression> arguments) {
                Expression assertThatArgument = (Expression)assertThatArg.getArguments().get(0);
                Expression methodToReplaceArgument = (Expression)methodToReplace.getArguments().get(0);
                boolean assertThatArgumentIsEmpty = assertThatArgument instanceof J.Empty;
                boolean methodToReplaceArgumentIsEmpty = methodToReplaceArgument instanceof J.Empty;
                if (assertThatArgumentIsEmpty && methodToReplaceArgumentIsEmpty) {
                    return "assertThat(#{any()}).%s()";
                }
                if (!assertThatArgumentIsEmpty && !methodToReplaceArgumentIsEmpty) {
                    arguments.add(assertThatArgument);
                    arguments.add(methodToReplaceArgument);
                    return "assertThat(#{any()}).%s(#{any()}, #{any()})";
                }
                arguments.add(this.extractEitherArgument(assertThatArgumentIsEmpty, assertThatArgument, methodToReplaceArgument));
                if ("java.nio.file.Path".equals(SimplifyChainedAssertJAssertion.this.requiredType) && SimplifyChainedAssertJAssertion.this.dedicatedAssertion.contains("Raw") && TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)assertThatArgument.getType())) {
                    this.maybeAddImport("java.nio.file.Path");
                    return "assertThat(#{any()}).%s(Path.of(#{any()}))";
                }
                return "assertThat(#{any()}).%s(#{any()})";
            }

            private Expression extractEitherArgument(boolean assertThatArgumentIsEmpty, Expression assertThatArgument, Expression methodToReplaceArgument) {
                if (assertThatArgumentIsEmpty) {
                    return methodToReplaceArgument;
                }
                if (chainedAssertMatcher.matches(assertThatArgument)) {
                    return Objects.requireNonNull(((J.MethodInvocation)assertThatArgument).getSelect());
                }
                return assertThatArgument;
            }
        };
    }

    @ConstructorProperties(value={"chainedAssertion", "assertToReplace", "dedicatedAssertion", "requiredType"})
    @Generated
    public SimplifyChainedAssertJAssertion(@Nullable String chainedAssertion, @Nullable String assertToReplace, @Nullable String dedicatedAssertion, @Nullable String requiredType) {
        this.chainedAssertion = chainedAssertion;
        this.assertToReplace = assertToReplace;
        this.dedicatedAssertion = dedicatedAssertion;
        this.requiredType = requiredType;
    }

    @Generated
    public SimplifyChainedAssertJAssertion() {
    }
}

