/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.search.IsLikelyTest;
import org.openrewrite.java.tree.J;

public class AddMockitoExtensionIfAnnotationsUsed
extends Recipe {
    public String getDisplayName() {
        return "Adds Mockito extensions to Mockito tests";
    }

    public String getDescription() {
        return "Adds `@ExtendWith(MockitoExtension.class)` to tests using `@Mock` or `@Captor`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor hasExtendedWithAnnotation = new FindAnnotations("org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)", Boolean.valueOf(false)).getVisitor();
        TreeVisitor[] hasAnyMockitoAnnotation = new TreeVisitor[]{new FindAnnotations("org.mockito.Captor", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.Mock", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.Spy", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.InjectMocks", Boolean.valueOf(false)).getVisitor()};
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new IsLikelyTest().getVisitor(), new FindTypes("org.junit.jupiter..*", Boolean.valueOf(false)).getVisitor(), Preconditions.not((TreeVisitor)hasExtendedWithAnnotation), Preconditions.or((TreeVisitor[])hasAnyMockitoAnnotation)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                this.maybeAddImport("org.mockito.junit.jupiter.MockitoExtension");
                this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                return (J.ClassDeclaration)JavaTemplate.builder((String)"@ExtendWith(MockitoExtension.class)").imports(new String[]{"org.mockito.junit.jupiter.MockitoExtension"}).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api", "mockito-junit-jupiter"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        });
    }
}

