/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Byte Assertions", description="Adopt AssertJ Byte Assertions. Favor semantically explicit methods (e.g. `myByte.isZero()` over `myByte.isEqualTo(0)`).")
public class AssertJByteRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractByteAssertIsOne {
        AbstractByteAssertIsOne() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isEqualTo((byte)1);
        }

        AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractByteAssertIsNotZero {
        AbstractByteAssertIsNotZero() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isNotEqualTo((byte)0);
        }

        AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractByteAssertIsZero {
        AbstractByteAssertIsZero() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isEqualTo((byte)0);
        }

        AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {
            return byteAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractByteAssertIsNotEqualTo {
        AbstractByteAssertIsNotEqualTo() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{byteAssert.isNotCloseTo(n, Offset.offset((Number)0)), byteAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {
            return byteAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractByteAssertIsEqualTo {
        AbstractByteAssertIsEqualTo() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{byteAssert.isCloseTo(n, Offset.offset((Number)0)), byteAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {
            return byteAssert.isEqualTo(n);
        }
    }
}

