/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitAssertFalseToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertFalse` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertFalse()` to AssertJ's `assertThat().isFalse()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(false)), (TreeVisitor)new AssertFalseToAssertThatVisitor());
    }

    public static class AssertFalseToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JavaParser.Builder<?, ?> assertionsParser;
        private static final MethodMatcher JUNIT_ASSERT_FALSE = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(boolean, ..)");

        private JavaParser.Builder<?, ?> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"});
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_FALSE.matches((MethodCall)method)) {
                return method;
            }
            List args = method.getArguments();
            Expression actual = (Expression)args.get(0);
            if (args.size() == 1) {
                method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(boolean)}).isFalse();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual});
            } else {
                Expression message = (Expression)args.get(1);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder((String)"assertThat(#{any(boolean)}).as(#{any(String)}).isFalse();") : JavaTemplate.builder((String)"assertThat(#{any(boolean)}).as(#{any(java.util.function.Supplier)}).isFalse();");
                method = (J.MethodInvocation)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message});
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat", false);
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            return method;
        }
    }
}

