/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class HamcrestAnyOfToAssertJ
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
    private static final MethodMatcher ANY_OF_MATCHER = new MethodMatcher("org.hamcrest.Matchers anyOf(..)");

    public String getDisplayName() {
        return "Migrate `anyOf` Hamcrest Matcher to AssertJ";
    }

    public String getDescription() {
        return "Migrate the `anyOf` Hamcrest Matcher to AssertJ's `satisfiesAnyOf` assertion.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ANY_OF_MATCHER), (TreeVisitor)new AnyOfToAssertJVisitor());
    }

    private static class AnyOfToAssertJVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private AnyOfToAssertJVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
            List arguments = mi.getArguments();
            Expression anyOfExpression = (Expression)arguments.get(arguments.size() - 1);
            if (!ASSERT_THAT_MATCHER.matches((MethodCall)mi) || !ANY_OF_MATCHER.matches(anyOfExpression)) {
                return mi;
            }
            List anyOfArguments = ((J.MethodInvocation)anyOfExpression).getArguments();
            if (TypeUtils.isAssignableTo((String)"java.lang.Iterable", (JavaType)((Expression)anyOfArguments.get(0)).getType())) {
                return mi;
            }
            StringBuilder template = new StringBuilder();
            ArrayList<Expression> parameters = new ArrayList<Expression>();
            template.append("assertThat(#{any()})\n");
            parameters.add((Expression)arguments.get(arguments.size() - 2));
            if (arguments.size() == 3) {
                template.append(".as(#{any(java.lang.String)})\n");
                parameters.add((Expression)arguments.get(0));
            }
            template.append(".satisfiesAnyOf(\n");
            template.append(anyOfArguments.stream().map(arg -> "arg -> assertThat(arg, #{any()})").collect(Collectors.joining(",\n")));
            parameters.addAll(anyOfArguments);
            template.append("\n);");
            this.maybeRemoveImport("org.hamcrest.Matchers.anyOf");
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            return (J.MethodInvocation)JavaTemplate.builder((String)template.toString()).contextSensitive().staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24", "hamcrest-2.2", "junit-jupiter-api-5.9"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), parameters.toArray());
        }
    }
}

