/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class TempDirNonFinal
extends Recipe {
    private static final AnnotationMatcher TEMPDIR_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.io.TempDir");

    public String getDisplayName() {
        return "Make `@TempDir` fields non final";
    }

    public String getDescription() {
        return "Make JUnit 5's `org.junit.jupiter.api.io.TempDir` fields non final.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.api.io.TempDir", Boolean.valueOf(false)), (TreeVisitor)new TempDirVisitor());
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    private static class TempDirVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private TempDirVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            if (varDecls.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)TEMPDIR_ANNOTATION_MATCHER).matches(arg_0)) && varDecls.hasModifier(J.Modifier.Type.Final)) {
                return (J.VariableDeclarations)this.maybeAutoFormat((J)varDecls, (J)varDecls.withModifiers(ListUtils.map((List)varDecls.getModifiers(), modifier -> modifier.getType() == J.Modifier.Type.Final ? null : modifier)), ctx, this.getCursor().getParentOrThrow());
            }
            return varDecls;
        }
    }
}

