/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.beans.ConstructorProperties;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;

final class HookArguments {
    private final String annotationName;
    @Nullable
    private final String tagExpression;
    @Nullable
    private final Integer order;
    private final J.Lambda lambda;

    String replacementImport() {
        return String.format("io.cucumber.java.%s", this.annotationName);
    }

    String template() {
        return "@#{}#{}\npublic void #{}(#{}) throws Exception {\n\t#{any()}\n}";
    }

    private String formatAnnotationArguments() {
        if (this.tagExpression == null && this.order == null) {
            return "";
        }
        StringBuilder template = new StringBuilder();
        template.append('(');
        if (this.order != null) {
            template.append("order = ").append(this.order);
            if (this.tagExpression != null) {
                template.append(", value = \"").append(this.tagExpression).append('\"');
            }
        } else {
            template.append('\"').append(this.tagExpression).append('\"');
        }
        template.append(')');
        return template.toString();
    }

    private String formatMethodName() {
        return String.format("%s%s%s", this.annotationName.replaceFirst("^Before", "before").replaceFirst("^After", "after"), this.tagExpression == null ? "" : "_tag_" + this.tagExpression.replaceAll("[^A-Za-z0-9]", "_"), this.order == null ? "" : "_order_" + this.order);
    }

    private String formatMethodArguments() {
        J firstLambdaParameter = (J)this.lambda.getParameters().getParameters().get(0);
        if (firstLambdaParameter instanceof J.VariableDeclarations) {
            return String.format("io.cucumber.java.Scenario %s", ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)firstLambdaParameter).getVariables().get(0)).getName());
        }
        return "";
    }

    public Object[] parameters() {
        return new Object[]{this.annotationName, this.formatAnnotationArguments(), this.formatMethodName(), this.formatMethodArguments(), this.lambda.getBody()};
    }

    @ConstructorProperties(value={"annotationName", "tagExpression", "order", "lambda"})
    public HookArguments(String annotationName, @Nullable String tagExpression, @Nullable Integer order, J.Lambda lambda) {
        this.annotationName = annotationName;
        this.tagExpression = tagExpression;
        this.order = order;
        this.lambda = lambda;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    @Nullable
    public String getTagExpression() {
        return this.tagExpression;
    }

    @Nullable
    public Integer getOrder() {
        return this.order;
    }

    public J.Lambda getLambda() {
        return this.lambda;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HookArguments)) {
            return false;
        }
        HookArguments other = (HookArguments)o;
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        String this$annotationName = this.getAnnotationName();
        String other$annotationName = other.getAnnotationName();
        if (this$annotationName == null ? other$annotationName != null : !this$annotationName.equals(other$annotationName)) {
            return false;
        }
        String this$tagExpression = this.getTagExpression();
        String other$tagExpression = other.getTagExpression();
        if (this$tagExpression == null ? other$tagExpression != null : !this$tagExpression.equals(other$tagExpression)) {
            return false;
        }
        J.Lambda this$lambda = this.getLambda();
        J.Lambda other$lambda = other.getLambda();
        return !(this$lambda == null ? other$lambda != null : !this$lambda.equals(other$lambda));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        String $annotationName = this.getAnnotationName();
        result = result * 59 + ($annotationName == null ? 43 : $annotationName.hashCode());
        String $tagExpression = this.getTagExpression();
        result = result * 59 + ($tagExpression == null ? 43 : $tagExpression.hashCode());
        J.Lambda $lambda = this.getLambda();
        result = result * 59 + ($lambda == null ? 43 : $lambda.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "HookArguments(annotationName=" + this.getAnnotationName() + ", tagExpression=" + this.getTagExpression() + ", order=" + this.getOrder() + ", lambda=" + this.getLambda() + ")";
    }

    @NonNull
    public HookArguments withTagExpression(@Nullable String tagExpression) {
        return this.tagExpression == tagExpression ? this : new HookArguments(this.annotationName, tagExpression, this.order, this.lambda);
    }

    @NonNull
    public HookArguments withOrder(@Nullable Integer order) {
        return this.order == order ? this : new HookArguments(this.annotationName, this.tagExpression, order, this.lambda);
    }
}

