/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.time.Duration;
import java.util.List;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.testing.cucumber.CucumberJava8ClassVisitor;
import org.openrewrite.java.testing.cucumber.HookArguments;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class CucumberJava8HookDefinitionToCucumberJava
extends Recipe {
    private static final String IO_CUCUMBER_JAVA8 = "io.cucumber.java8";
    private static final String IO_CUCUMBER_JAVA8_HOOK_BODY = "io.cucumber.java8.HookBody";
    private static final String IO_CUCUMBER_JAVA8_HOOK_NO_ARGS_BODY = "io.cucumber.java8.HookNoArgsBody";
    private static final String HOOK_BODY_DEFINITION = "io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookBody)";
    private static final String HOOK_NO_ARGS_BODY_DEFINITION = "io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookNoArgsBody)";
    private static final MethodMatcher HOOK_BODY_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookBody)");
    private static final MethodMatcher HOOK_NO_ARGS_BODY_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookNoArgsBody)");

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(HOOK_BODY_DEFINITION, true), new UsesMethod(HOOK_NO_ARGS_BODY_DEFINITION, true)});
    }

    public String getDisplayName() {
        return "Replace Cucumber-Java8 hook definition with Cucumber-Java";
    }

    public String getDescription() {
        return "Replace LambdaGlue hook definitions with new annotated methods with the same body.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CucumberJava8HooksVisitor();
    }

    static final class CucumberJava8HooksVisitor
    extends JavaVisitor<ExecutionContext> {
        CucumberJava8HooksVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext p) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)super.visitMethodInvocation(mi, (Object)p);
            if (!HOOK_BODY_DEFINITION_METHOD_MATCHER.matches(methodInvocation) && !HOOK_NO_ARGS_BODY_DEFINITION_METHOD_MATCHER.matches(methodInvocation)) {
                return methodInvocation;
            }
            if (methodInvocation.getArguments().stream().anyMatch(arg -> !(arg instanceof J.Literal) && !(arg instanceof J.Lambda))) {
                return (J)SearchResult.found((Tree)methodInvocation, (String)"TODO Migrate manually");
            }
            HookArguments hookArguments = this.parseHookArguments(methodInvocation.getSimpleName(), methodInvocation.getArguments());
            J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            this.doAfterVisit((TreeVisitor)new CucumberJava8ClassVisitor(parentClass.getType(), hookArguments.replacementImport(), hookArguments.template(), hookArguments.parameters()));
            return null;
        }

        HookArguments parseHookArguments(String methodName, List<Expression> arguments) {
            int argumentsSize = arguments.size();
            Expression lambdaArgument = arguments.get(argumentsSize - 1);
            HookArguments hookArguments = new HookArguments(methodName, null, null, (J.Lambda)lambdaArgument);
            if (argumentsSize == 1) {
                return hookArguments;
            }
            J.Literal firstArgument = (J.Literal)arguments.get(0);
            if (argumentsSize == 2) {
                if (firstArgument.getType() == JavaType.Primitive.String) {
                    return hookArguments.withTagExpression((String)firstArgument.getValue());
                }
                return hookArguments.withOrder((Integer)firstArgument.getValue());
            }
            return hookArguments.withTagExpression((String)firstArgument.getValue()).withOrder((Integer)((J.Literal)arguments.get(1)).getValue());
        }
    }
}

