/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class JUnitFailToAssertJFail
extends Recipe {
    public String getDisplayName() {
        return "JUnit fail to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `fail()` to AssertJ's `fail()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Assertions");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JUnitFailToAssertJFailVisitor();
    }

    public static class JUnitFailToAssertJFailVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Supplier<JavaParser> ASSERTJ_JAVA_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"}).build();
        private static final MethodMatcher JUNIT_FAIL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (!JUNIT_FAIL_MATCHER.matches(m)) {
                return m;
            }
            List args = m.getArguments();
            if (args.size() == 1) {
                m = args.get(0) instanceof J.Empty ? (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((JUnitFailToAssertJFailVisitor)this).getCursor(), (String)"org.assertj.core.api.Assertions.fail(\"\");").javaParser(this.ASSERTJ_JAVA_PARSER).build(), m.getCoordinates().replace(), new Object[0]) : (args.get(0) instanceof J.Literal ? (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((JUnitFailToAssertJFailVisitor)this).getCursor(), (String)"org.assertj.core.api.Assertions.fail(#{});").javaParser(this.ASSERTJ_JAVA_PARSER).build(), m.getCoordinates().replace(), new Object[]{args.get(0)}) : (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((JUnitFailToAssertJFailVisitor)this).getCursor(), (String)"org.assertj.core.api.Assertions.fail(\"\", #{any()});").javaParser(this.ASSERTJ_JAVA_PARSER).build(), m.getCoordinates().replace(), new Object[]{args.get(0)}));
            } else {
                StringBuilder templateBuilder = new StringBuilder("org.assertj.core.api.Assertions.fail(");
                for (int i = 0; i < args.size(); ++i) {
                    templateBuilder.append("#{any()}");
                    if (i >= args.size() - 1) continue;
                    templateBuilder.append(", ");
                }
                templateBuilder.append(");");
                m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((JUnitFailToAssertJFailVisitor)this).getCursor(), (String)templateBuilder.toString()).javaParser(this.ASSERTJ_JAVA_PARSER).build(), m.getCoordinates().replace(), args.toArray());
            }
            this.doAfterVisit((Recipe)new RemoveUnusedImports());
            this.doAfterVisit((TreeVisitor)new UnqualifiedMethodInvocations());
            return m;
        }

        private static class UnqualifiedMethodInvocations
        extends JavaIsoVisitor<ExecutionContext> {
            private final Supplier<JavaParser> ASSERTJ_JAVA_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"}).build();
            private static final MethodMatcher ASSERTJ_FAIL_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions fail(..)");

            private UnqualifiedMethodInvocations() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (!ASSERTJ_FAIL_MATCHER.matches(method)) {
                    return method;
                }
                StringBuilder templateBuilder = new StringBuilder("fail(");
                List arguments = method.getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    templateBuilder.append("#{any()}");
                    if (i >= arguments.size() - 1) continue;
                    templateBuilder.append(", ");
                }
                templateBuilder.append(");");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((UnqualifiedMethodInvocations)this).getCursor(), (String)templateBuilder.toString()).staticImports(new String[]{"org.assertj.core.api.Assertions.fail"}).javaParser(this.ASSERTJ_JAVA_PARSER).build(), method.getCoordinates().replace(), arguments.toArray());
                this.maybeAddImport("org.assertj.core.api.Assertions", "fail");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        }
    }
}

