/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertArrayEqualsToAssertThat
extends Recipe {
    private static final String JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.junit.jupiter.api.Assertions";

    public String getDisplayName() {
        return "JUnit `assertArrayEquals` To AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertArrayEquals()` to AssertJ's `assertThat().contains()` equivalents.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType(JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AssertArrayEqualsToAssertThatVisitor();
    }

    public static class AssertArrayEqualsToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher JUNIT_ASSERT_EQUALS = new MethodMatcher("org.junit.jupiter.api.Assertions assertArrayEquals(..)");
        private static final Supplier<JavaParser> ASSERTIONS_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"}).build();

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_EQUALS.matches(method)) {
                return method;
            }
            List args = method.getArguments();
            Expression expected = (Expression)args.get(0);
            Expression actual = (Expression)args.get(1);
            if (args.size() == 2) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(ASSERTIONS_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual, expected});
            } else if (args.size() == 3 && !AssertArrayEqualsToAssertThatVisitor.isFloatingPointType((Expression)args.get(2))) {
                Expression message = (Expression)args.get(2);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).as(#{any(String)}).containsExactly(#{anyArray()});") : JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).as(#{any(java.util.function.Supplier)}).containsExactly(#{anyArray()});");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(ASSERTIONS_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual, message, expected});
            } else if (args.size() == 3) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(ASSERTIONS_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
                this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            } else {
                Expression message = (Expression)args.get(3);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).as(#{any(String)}).containsExactly(#{anyArray()}, within(#{any()}));") : JavaTemplate.builder(() -> ((AssertArrayEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{anyArray()}).as(#{any(java.util.function.Supplier)}).containsExactly(#{anyArray()}, within(#{}));");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(ASSERTIONS_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
                this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport(JUnitAssertArrayEqualsToAssertThat.JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME);
            return method;
        }

        private static boolean isFloatingPointType(Expression expression) {
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
            if (fullyQualified != null) {
                String typeName = fullyQualified.getFullyQualifiedName();
                return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
            }
            JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
            return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
        }
    }
}

