/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public final class DefaultComesLastVisitor<P>
extends JavaIsoVisitor<P> {
    private final DefaultComesLastStyle style;

    public J.Switch visitSwitch(J.Switch switch_, P p) {
        J.Switch s = (J.Switch)this.visitAndCast((Tree)switch_, p, (x$0, x$1) -> super.visitSwitch(x$0, x$1));
        if (!this.isDefaultCaseLastOrNotPresent(switch_)) {
            J.Case lastNotGroupedWithDefault;
            J.Case lastGroupedWithDefault;
            J.Case aCase;
            int i;
            List cases = s.getCases().getStatements().stream().map(J.Case.class::cast).collect(Collectors.toList());
            ArrayList<Object> fixedCases = new ArrayList<Object>(cases.size());
            int defaultCaseIndex = -1;
            J.Case defaultCase = null;
            for (int i2 = 0; i2 < cases.size(); ++i2) {
                J.Case aCase2 = (J.Case)cases.get(i2);
                if (aCase2.getBody() != null) {
                    return s;
                }
                if (!this.isDefaultCase(aCase2)) continue;
                defaultCaseIndex = i2;
                defaultCase = aCase2;
            }
            ArrayList<J.Case> casesGroupedWithDefault = new ArrayList<J.Case>();
            boolean foundNonEmptyCase = false;
            for (i = defaultCaseIndex - 1; i >= 0; --i) {
                aCase = (J.Case)cases.get(i);
                if (aCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(0, aCase);
                    continue;
                }
                foundNonEmptyCase = true;
                fixedCases.add(0, aCase);
            }
            foundNonEmptyCase = false;
            for (i = defaultCaseIndex + 1; i < cases.size(); ++i) {
                aCase = (J.Case)cases.get(i);
                if (defaultCase != null && defaultCase.getStatements().isEmpty() && aCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(aCase);
                    continue;
                }
                if (defaultCase != null && defaultCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(aCase);
                }
                foundNonEmptyCase = true;
                fixedCases.add(aCase);
            }
            if (defaultCase != null && !casesGroupedWithDefault.isEmpty() && !(lastGroupedWithDefault = (J.Case)casesGroupedWithDefault.get(casesGroupedWithDefault.size() - 1)).getStatements().isEmpty()) {
                casesGroupedWithDefault.set(casesGroupedWithDefault.size() - 1, lastGroupedWithDefault.withStatements(Collections.emptyList()));
                defaultCase = defaultCase.withStatements(lastGroupedWithDefault.getStatements());
            }
            if (!(lastNotGroupedWithDefault = (J.Case)fixedCases.get(fixedCases.size() - 1)).getStatements().stream().reduce((s1, s2) -> s2).map(stat -> stat instanceof J.Break || stat instanceof J.Continue || stat instanceof J.Return || stat instanceof J.Throw).orElse(false).booleanValue()) {
                ArrayList<J.Break> statementsOfCaseBeingMoved = new ArrayList<J.Break>(lastNotGroupedWithDefault.getStatements());
                J.Break breakStatement = (J.Break)this.autoFormat((J)new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null), p);
                statementsOfCaseBeingMoved.add(breakStatement);
                lastNotGroupedWithDefault = lastNotGroupedWithDefault.withStatements(ListUtils.map(statementsOfCaseBeingMoved, stmt -> (Statement)this.autoFormat((J)stmt, p, this.getCursor())));
                fixedCases.set(fixedCases.size() - 1, lastNotGroupedWithDefault);
            }
            fixedCases.addAll(casesGroupedWithDefault);
            if (defaultCase != null) {
                if (defaultCase.getStatements().stream().reduce((s1, s2) -> s2).map(stat -> stat instanceof J.Break || stat instanceof J.Continue || this.isVoidReturn((Statement)stat)).orElse(false).booleanValue()) {
                    ArrayList fixedDefaultStatements = new ArrayList(defaultCase.getStatements());
                    fixedDefaultStatements.remove(fixedDefaultStatements.size() - 1);
                    fixedCases.add(defaultCase.withStatements(fixedDefaultStatements));
                } else {
                    fixedCases.add(defaultCase);
                }
            }
            boolean changed = true;
            if (cases.size() == fixedCases.size()) {
                changed = false;
                for (int i3 = 0; i3 < cases.size(); ++i3) {
                    if (cases.get(i3) == fixedCases.get(i3)) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                s = s.withCases(s.getCases().withStatements(fixedCases.stream().map(Statement.class::cast).collect(Collectors.toList())));
            }
        }
        return s;
    }

    private boolean isVoidReturn(Statement stat) {
        return stat instanceof J.Return && ((J.Return)stat).getExpression() == null;
    }

    private boolean isDefaultCaseLastOrNotPresent(J.Switch switch_) {
        J.Case defaultCase = null;
        J.Case prior = null;
        for (Statement aCaseStmt : switch_.getCases().getStatements()) {
            if (!(aCaseStmt instanceof J.Case)) continue;
            J.Case aCase = (J.Case)aCaseStmt;
            if (defaultCase != null) {
                return false;
            }
            if (this.isDefaultCase(aCase)) {
                defaultCase = aCase;
            }
            if (defaultCase != null && prior != null && Boolean.TRUE.equals(this.style.getSkipIfLastAndSharedWithCase()) && prior.getStatements().isEmpty()) {
                return true;
            }
            prior = aCase;
        }
        return true;
    }

    private boolean isDefaultCase(J.Case case_) {
        J elem = (J)case_.getCaseLabels().get(0);
        return elem instanceof J.Identifier && ((J.Identifier)elem).getSimpleName().equals("default");
    }

    @Generated
    public DefaultComesLastVisitor(DefaultComesLastStyle style) {
        this.style = style;
    }

    @Generated
    public DefaultComesLastStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "DefaultComesLastVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultComesLastVisitor)) {
            return false;
        }
        DefaultComesLastVisitor other = (DefaultComesLastVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DefaultComesLastStyle this$style = this.getStyle();
        DefaultComesLastStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultComesLastVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultComesLastStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }
}

