/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.format.TabsAndIndents;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public final class UseAsBuilder
extends Recipe {
    @Option(displayName="Builder Type", description="Fully qualified name of the Builder", example="org.example.Buildable.Builder")
    private final String builderType;
    @Option(displayName="Immutable state", description="The builder is immutable if you must assign the result of calls to intermediate variables or use directly. Defaults to true as many purpose-built builders will be immutable.", required=false)
    private final @Nullable Boolean immutable;
    @Option(displayName="Builder creator method", description="The method that creates the builder instance, which may not be a method of the builder itself.", required=false, example="org.example.Buildable builder()")
    private final @Nullable String builderCreator;
    private final String displayName = "Chain calls to builder methods";
    private final String description = "Chain calls to builder methods that are on separate lines into one chain of builder calls.";

    public Validated<Object> validate() {
        return super.validate().and(Validated.notBlank((String)"builderType", (String)this.builderType));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> v = new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher builderCall;
            {
                this.builderCall = new MethodMatcher(UseAsBuilder.this.builderType + " *(..)");
            }

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                Map<String, List<Statement>> builderCalls = this.collectBuilderMethodsByVariable(b);
                if (builderCalls.values().stream().map(List::size).max(Integer::sum).orElse(0) > 1) {
                    List<Statement> statements = this.consolidateAllBuilderCalls(block, builderCalls);
                    return b.withStatements(statements);
                }
                return b;
            }

            private List<Statement> consolidateAllBuilderCalls(J.Block block, Map<String, List<Statement>> builderCalls) {
                ArrayList<Statement> statements = new ArrayList<Statement>();
                ArrayList beforeBuilder = new ArrayList();
                ArrayList<Statement> afterBuilder = new ArrayList<Statement>();
                J.VariableDeclarations consolidatedBuilder = null;
                Iterator builderCallIter = builderCalls.values().stream().flatMap(Collection::stream).iterator();
                Statement currentBuilderCall = (Statement)builderCallIter.next();
                for (Statement statement : block.getStatements()) {
                    if (currentBuilderCall != null) {
                        if (statement == currentBuilderCall) {
                            if (statement instanceof J.VariableDeclarations) {
                                if (consolidatedBuilder != null) {
                                    statements.addAll(beforeBuilder);
                                    statements.add((Statement)consolidatedBuilder);
                                    statements.addAll(afterBuilder);
                                    beforeBuilder.clear();
                                    afterBuilder.clear();
                                }
                                consolidatedBuilder = (J.VariableDeclarations)statement;
                            } else {
                                assert (consolidatedBuilder != null);
                                if (statement instanceof J.Assignment) {
                                    J.Assignment assign = (J.Assignment)statement;
                                    consolidatedBuilder = this.consolidateBuilder(consolidatedBuilder, (J.MethodInvocation)assign.getAssignment());
                                } else if (statement instanceof J.MethodInvocation) {
                                    consolidatedBuilder = this.consolidateBuilder(consolidatedBuilder, (J.MethodInvocation)statement);
                                }
                                beforeBuilder.addAll(afterBuilder);
                                afterBuilder.clear();
                            }
                            currentBuilderCall = builderCallIter.hasNext() ? (Statement)builderCallIter.next() : null;
                            continue;
                        }
                        afterBuilder.add(statement);
                        continue;
                    }
                    afterBuilder.add(statement);
                }
                statements.addAll(beforeBuilder);
                if (consolidatedBuilder != null) {
                    statements.add((Statement)consolidatedBuilder);
                }
                statements.addAll(afterBuilder);
                return statements;
            }

            private Map<String, List<Statement>> collectBuilderMethodsByVariable(J.Block b) {
                LinkedHashMap<String, List<Statement>> builderCalls = new LinkedHashMap<String, List<Statement>>();
                for (Statement stat : b.getStatements()) {
                    J.MethodInvocation method;
                    if (stat instanceof J.VariableDeclarations) {
                        J.VariableDeclarations varDecs = (J.VariableDeclarations)stat;
                        for (J.VariableDeclarations.NamedVariable namedVar : varDecs.getVariables()) {
                            if (!this.matchesBuilder(namedVar.getInitializer())) continue;
                            builderCalls.computeIfAbsent(namedVar.getSimpleName(), n -> new ArrayList()).add(stat);
                        }
                        continue;
                    }
                    if (stat instanceof J.Assignment) {
                        J.Assignment assign = (J.Assignment)stat;
                        if (!this.matchesBuilder(assign.getAssignment())) continue;
                        builderCalls.computeIfAbsent(assign.getVariable().printTrimmed(this.getCursor()), n -> new ArrayList()).add(stat);
                        continue;
                    }
                    if (Boolean.FALSE.equals(UseAsBuilder.this.immutable) || !(stat instanceof J.MethodInvocation) || !this.matchesBuilder((Expression)(method = (J.MethodInvocation)stat)) || method.getSelect() == null) continue;
                    builderCalls.computeIfAbsent(method.getSelect().printTrimmed(this.getCursor()), n -> new ArrayList()).add(stat);
                }
                return builderCalls;
            }

            private boolean matchesBuilder(@Nullable Expression j) {
                return this.builderCall.matches(j) || UseAsBuilder.this.builderCreator != null && new MethodMatcher(UseAsBuilder.this.builderCreator).matches(j);
            }

            private J.VariableDeclarations consolidateBuilder(J.VariableDeclarations consolidatedBuilder, J.MethodInvocation builderCall) {
                J.VariableDeclarations cb = consolidatedBuilder.withVariables(ListUtils.map((List)consolidatedBuilder.getVariables(), nv -> {
                    Expression init = nv.getInitializer();
                    assert (init != null);
                    return nv.withInitializer((Expression)builderCall.getPadding().withSelect(JRightPadded.build((Object)((Expression)init.withPrefix(Space.EMPTY))).withAfter(Space.format((String)"\n"))));
                }));
                return (J.VariableDeclarations)TabsAndIndents.formatTabsAndIndents((J)cb, (Cursor)this.getCursor());
            }
        };
        return this.builderCreator == null ? v : Preconditions.check((TreeVisitor)new UsesMethod(this.builderCreator), (TreeVisitor)v);
    }

    @Generated
    public UseAsBuilder(String builderType, @Nullable Boolean immutable, @Nullable String builderCreator) {
        this.builderType = builderType;
        this.immutable = immutable;
        this.builderCreator = builderCreator;
    }

    @Generated
    public String getBuilderType() {
        return this.builderType;
    }

    @Generated
    public @Nullable Boolean getImmutable() {
        return this.immutable;
    }

    @Generated
    public @Nullable String getBuilderCreator() {
        return this.builderCreator;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "UseAsBuilder(builderType=" + this.getBuilderType() + ", immutable=" + this.getImmutable() + ", builderCreator=" + this.getBuilderCreator() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseAsBuilder)) {
            return false;
        }
        UseAsBuilder other = (UseAsBuilder)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$immutable = this.getImmutable();
        Boolean other$immutable = other.getImmutable();
        if (this$immutable == null ? other$immutable != null : !((Object)this$immutable).equals(other$immutable)) {
            return false;
        }
        String this$builderType = this.getBuilderType();
        String other$builderType = other.getBuilderType();
        if (this$builderType == null ? other$builderType != null : !this$builderType.equals(other$builderType)) {
            return false;
        }
        String this$builderCreator = this.getBuilderCreator();
        String other$builderCreator = other.getBuilderCreator();
        if (this$builderCreator == null ? other$builderCreator != null : !this$builderCreator.equals(other$builderCreator)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UseAsBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $immutable = this.getImmutable();
        result = result * 59 + ($immutable == null ? 43 : ((Object)$immutable).hashCode());
        String $builderType = this.getBuilderType();
        result = result * 59 + ($builderType == null ? 43 : $builderType.hashCode());
        String $builderCreator = this.getBuilderCreator();
        result = result * 59 + ($builderCreator == null ? 43 : $builderCreator.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

