/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class UnwrapElseAfterReturn
extends Recipe {
    final String displayName = "Unwrap else block after return or throw statement";
    final String description = "Unwraps the else block when the if block ends with a return or throw statement, reducing nesting and improving code readability.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = (J.Block)this.visitAndCast((Tree)block, ctx, (x$0, x$1) -> super.visitBlock(x$0, x$1));
                AtomicReference<@Nullable Object> endWhitespace = new AtomicReference<Object>(null);
                J.Block alteredBlock = b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.If ifStatement;
                    if (statement instanceof J.If && (ifStatement = (J.If)statement).getElsePart() != null && this.endsWithReturnOrThrow(ifStatement.getThenPart())) {
                        @Nullable Statement elsePart = ifStatement.getElsePart().getBody();
                        if (elsePart instanceof J.If) {
                            J.If innermost = this.findInnermostIfWithElse((J.If)elsePart);
                            if (innermost != null && innermost.getElsePart() != null && this.endsWithReturnOrThrow(innermost.getThenPart()) && !(innermost.getElsePart().getBody() instanceof J.If)) {
                                J.If modifiedChain = this.removeInnermostElse(ifStatement);
                                Statement innermostElseBody = innermost.getElsePart().getBody();
                                return this.flatten(innermost, innermostElseBody, endWhitespace, modifiedChain);
                            }
                        } else {
                            J.If newIf = ifStatement.withElsePart(null);
                            return this.flatten(ifStatement, elsePart, endWhitespace, newIf);
                        }
                    }
                    return statement;
                }));
                Space end = endWhitespace.get();
                if (end != null) {
                    List mergedComments = ListUtils.concatAll((List)end.getComments(), (List)b.getEnd().getComments());
                    alteredBlock = alteredBlock.withEnd(b.getEnd().withComments(mergedComments).withWhitespace(end.getWhitespace()));
                }
                return (J.Block)this.maybeAutoFormat((J)b, (J)alteredBlock, ctx);
            }

            private List<Statement> flatten(J.If tailIf, Statement tailElse, AtomicReference<@Nullable Space> endWhitespace, J.If ifWithoutElse) {
                if (tailElse instanceof J.Block) {
                    J.Block elseBlock = (J.Block)tailElse;
                    endWhitespace.set(elseBlock.getEnd());
                    return ListUtils.concat((Object)ifWithoutElse, (List)ListUtils.mapFirst((List)elseBlock.getStatements(), elseStmt -> {
                        List elseComments = elseBlock.getPrefix().getComments();
                        List stmtComments = elseStmt.getPrefix().getComments();
                        if (!elseComments.isEmpty() || !stmtComments.isEmpty()) {
                            return (Statement)elseStmt.withComments(ListUtils.concatAll((List)elseComments, (List)stmtComments));
                        }
                        String whitespace = tailIf.getElsePart().getPrefix().getWhitespace();
                        return (Statement)elseStmt.withPrefix(elseStmt.getPrefix().withWhitespace(whitespace));
                    }));
                }
                return Arrays.asList(ifWithoutElse, (Statement)tailElse.withPrefix(tailIf.getElsePart().getPrefix()));
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.If findInnermostIfWithElse(J.If ifStatement) {
                if (ifStatement.getElsePart() == null) {
                    return null;
                }
                Statement elseBody = ifStatement.getElsePart().getBody();
                if (elseBody instanceof J.If) {
                    J.If result = this.findInnermostIfWithElse((J.If)elseBody);
                    return result != null ? result : ifStatement;
                }
                return ifStatement;
            }

            private J.If removeInnermostElse(J.If ifStatement) {
                if (ifStatement.getElsePart() == null) {
                    return ifStatement;
                }
                Statement elseBody = ifStatement.getElsePart().getBody();
                if (elseBody instanceof J.If) {
                    J.If innerIf = (J.If)elseBody;
                    if (innerIf.getElsePart() != null && !(innerIf.getElsePart().getBody() instanceof J.If)) {
                        return ifStatement.withElsePart(ifStatement.getElsePart().withBody((Statement)innerIf.withElsePart(null)));
                    }
                    return ifStatement.withElsePart(ifStatement.getElsePart().withBody((Statement)this.removeInnermostElse(innerIf)));
                }
                return ifStatement.withElsePart(null);
            }

            private boolean endsWithReturnOrThrow(Statement statement) {
                J.Block block;
                if (statement instanceof J.Return || statement instanceof J.Throw) {
                    return true;
                }
                if (statement instanceof J.Block && !(block = (J.Block)statement).getStatements().isEmpty()) {
                    Statement lastStatement = (Statement)block.getStatements().get(block.getStatements().size() - 1);
                    return lastStatement instanceof J.Return || lastStatement instanceof J.Throw;
                }
                return false;
            }
        };
        return Repeat.repeatUntilStable((TreeVisitor)javaVisitor);
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

