/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class UnnecessaryExplicitTypeArguments
extends Recipe {
    final String displayName = "Unnecessary explicit type arguments";
    final String description = "When explicit type arguments are inferable by the compiler, they may be removed.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                JavaType.Method methodType = m.getMethodType();
                if (methodType == null || m.getTypeParameters() == null || m.getTypeParameters().isEmpty()) {
                    return m;
                }
                Object enclosing = this.getCursor().getParentTreeCursor().getValue();
                if (enclosing instanceof J.Ternary) {
                    return m;
                }
                JavaType inferredType = null;
                if (enclosing instanceof J.MethodInvocation) {
                    if (this.shouldRetainOnStaticMethod(methodType)) {
                        return m;
                    }
                    J.MethodInvocation enclosingMethod = (J.MethodInvocation)enclosing;
                    if (enclosingMethod.getMethodType() == null) {
                        return m;
                    }
                    if (!(enclosingMethod.getMethodType().getDeclaringType() instanceof JavaType.Class)) {
                        return m;
                    }
                    JavaType.Class declaringClass = (JavaType.Class)enclosingMethod.getMethodType().getDeclaringType();
                    if (declaringClass.getMethods().stream().filter(it -> it.getName().equals(enclosingMethod.getSimpleName())).count() > 1L) {
                        return m;
                    }
                    inferredType = methodType.getReturnType();
                } else if (enclosing instanceof Expression) {
                    inferredType = ((Expression)enclosing).getType();
                } else if (enclosing instanceof NameTree) {
                    J.VariableDeclarations decl;
                    if (enclosing instanceof J.VariableDeclarations.NamedVariable && (decl = (J.VariableDeclarations)this.getCursor().getParentTreeCursor().getParentTreeCursor().getValue()).getTypeExpression() instanceof J.Identifier && "var".equals(((J.Identifier)decl.getTypeExpression()).getSimpleName())) {
                        return m;
                    }
                    inferredType = ((NameTree)enclosing).getType();
                } else if (enclosing instanceof J.Return) {
                    Object e = this.getCursor().dropParentUntil(p -> p instanceof J.MethodDeclaration || p instanceof J.Lambda || "root".equals(p)).getValue();
                    if (e instanceof J.MethodDeclaration) {
                        J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)e;
                        if (methodDeclaration.getReturnTypeExpression() != null) {
                            inferredType = methodDeclaration.getReturnTypeExpression().getType();
                        }
                    } else if (e instanceof J.Lambda) {
                        inferredType = ((J.Lambda)e).getType();
                    }
                }
                if (inferredType != null && TypeUtils.isOfType((JavaType)inferredType, (JavaType)methodType.getReturnType())) {
                    m = m.withTypeParameters(null);
                }
                return m;
            }

            private boolean shouldRetainOnStaticMethod(JavaType.Method methodType) {
                if (!methodType.hasFlags(new Flag[]{Flag.Static})) {
                    return false;
                }
                ArrayList formalTypeNames = new ArrayList(methodType.getDeclaredFormalTypeNames());
                methodType.getParameterTypes().stream().filter(p -> p instanceof JavaType.Parameterized).flatMap(p -> ((JavaType.Parameterized)p).getTypeParameters().stream()).filter(t -> t instanceof JavaType.GenericTypeVariable).forEach(it -> formalTypeNames.remove(((JavaType.GenericTypeVariable)it).getName()));
                return !formalTypeNames.isEmpty();
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

