/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.marker.IsNullSafe;

public class SimplifyBooleanExpression
extends Recipe {
    final String displayName = "Simplify boolean expression";
    final String description = "Checks for overly complicated boolean expressions, such as `if (b == true)`, `b || true`, `!false`, etc.";
    final Set<String> tags = Collections.singleton("RSPEC-1125");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SimplifyBooleanExpressionVisitor(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                return (J)super.visit(tree, (Object)ctx);
            }

            protected boolean shouldSimplifyEqualsOn(@Nullable J j) {
                return !(j instanceof J.MethodInvocation) || !j.getMarkers().findFirst(IsNullSafe.class).isPresent();
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

