/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceWeekYearWithYear
extends Recipe {
    private static final MethodMatcher SIMPLE_DATE_FORMAT_CONSTRUCTOR_MATCHER = new MethodMatcher("java.text.SimpleDateFormat <constructor>(..)");
    private static final MethodMatcher OF_PATTERN_MATCHER = new MethodMatcher("java.time.format.DateTimeFormatter ofPattern(..)");
    final String displayName = "Week Year (YYYY) should not be used for date formatting";
    final String description = "For most dates Week Year (YYYY) and Year (yyyy) yield the same results. However, on the last week of December and the first week of January, Week Year could produce unexpected results.";
    final Set<String> tags = Collections.singleton("RSPEC-S3986");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(SIMPLE_DATE_FORMAT_CONSTRUCTOR_MATCHER), new UsesMethod(OF_PATTERN_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (OF_PATTERN_MATCHER.matches((MethodCall)mi)) {
                    this.getCursor().putMessage("KEY", (Object)mi);
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }

            public J.NewClass visitNewClass(J.NewClass nc, ExecutionContext ctx) {
                if (SIMPLE_DATE_FORMAT_CONSTRUCTOR_MATCHER.matches((MethodCall)nc)) {
                    this.getCursor().putMessage("KEY", (Object)nc);
                }
                return super.visitNewClass(nc, (Object)ctx);
            }

            public J.Literal visitLiteral(J.Literal li, ExecutionContext ctx) {
                Object value;
                String newValue;
                Cursor c;
                if (li.getValue() instanceof String && (c = this.getCursor().dropParentWhile(is -> is instanceof J.Parentheses || !(is instanceof Tree))).getMessage("KEY") != null && !(newValue = this.replaceY((value = li.getValue()).toString())).equals(value.toString())) {
                    return li.withValueSource("\"" + newValue + "\"").withValue((Object)newValue);
                }
                return li;
            }

            private String replaceY(String input) {
                StringBuilder output = new StringBuilder();
                boolean insideQuotes = false;
                for (int i = 0; i < input.length(); ++i) {
                    char currentChar = input.charAt(i);
                    if (currentChar == '\'') {
                        insideQuotes = !insideQuotes;
                        output.append(currentChar);
                        continue;
                    }
                    if (currentChar == 'Y' && !insideQuotes) {
                        output.append('y');
                        continue;
                    }
                    if (currentChar == 'w' && !insideQuotes) {
                        return input;
                    }
                    output.append(currentChar);
                }
                return output.toString();
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

