/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceStringConcatenationWithStringValueOf
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.lang.String#valueOf(..)", false);
    final String displayName = "Replace String concatenation with `String.valueOf()`";
    final String description = "Replace inefficient string concatenation patterns like `\"\" + ...` with `String.valueOf(...)`. This improves code readability and may have minor performance benefits.";
    final Set<String> tags = Collections.singleton("RSPEC-S1153");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public <T extends J> J visitParentheses(J.Parentheses<T> parens, ExecutionContext ctx) {
                J tree;
                J p = super.visitParentheses(parens, (Object)ctx);
                if (p instanceof J.Parentheses && (tree = ((J.Parentheses)p).getTree()) instanceof J.MethodInvocation && METHOD_MATCHER.matches((MethodCall)tree)) {
                    return tree.withPrefix(p.getPrefix());
                }
                return p;
            }

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                if (!(!J.Literal.isLiteralValue((Expression)binary.getLeft(), (Object)"") || binary.getOperator() != J.Binary.Type.Addition || TypeUtils.isString((JavaType)binary.getRight().getType()) || J.Literal.isLiteralValue((Expression)binary.getRight(), null) || binary.getRight() instanceof J.Binary || this.getCursor().getParentTreeCursor().getValue() instanceof J.Binary)) {
                    return JavaTemplate.builder((String)"String.valueOf(#{any()})").build().apply(this.getCursor(), binary.getCoordinates().replace(), new Object[]{binary.getRight() instanceof J.Parentheses ? ((J.Parentheses)binary.getRight()).getTree() : binary.getRight()}).withPrefix(binary.getPrefix());
                }
                return super.visitBinary(binary, (Object)ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

