/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class RemoveRedundantNullCheckBeforeInstanceof
extends Recipe {
    private final String displayName = "Remove redundant null checks before instanceof";
    private final String description = "Removes redundant null checks before instanceof operations since instanceof returns false for null.";
    private final Set<String> tags = Collections.singleton("RSPEC-S1697");
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new KotlinFileChecker()), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.InstanceOf instanceOf;
                J.Binary nullCheck;
                J.Binary bi = (J.Binary)super.visitBinary(binary, (Object)ctx);
                if (bi.getOperator() != J.Binary.Type.And) {
                    return bi;
                }
                Expression left = bi.getLeft();
                Expression right = bi.getRight();
                if (left instanceof J.Binary && right instanceof J.InstanceOf && this.isRedundantNullCheck(nullCheck = (J.Binary)left, instanceOf = (J.InstanceOf)right)) {
                    return instanceOf.withPrefix(bi.getPrefix());
                }
                if (left instanceof J.Binary && ((J.Binary)left).getOperator() == J.Binary.Type.And && right instanceof J.InstanceOf) {
                    J.Binary leftBinary = (J.Binary)left;
                    instanceOf = (J.InstanceOf)right;
                    Expression rightmostOfLeft = leftBinary.getRight();
                    if (rightmostOfLeft instanceof J.Binary && this.isRedundantNullCheck((J.Binary)rightmostOfLeft, instanceOf)) {
                        return bi.withLeft(leftBinary.getLeft()).withRight((Expression)instanceOf);
                    }
                }
                return bi;
            }

            private boolean isRedundantNullCheck(J.Binary nullCheck, J.InstanceOf instanceOf) {
                if (nullCheck.getOperator() == J.Binary.Type.NotEqual) {
                    if (J.Literal.isLiteralValue((Expression)nullCheck.getLeft(), null)) {
                        return SemanticallyEqual.areEqual((J)nullCheck.getRight(), (J)instanceOf.getExpression());
                    }
                    if (J.Literal.isLiteralValue((Expression)nullCheck.getRight(), null)) {
                        return SemanticallyEqual.areEqual((J)nullCheck.getLeft(), (J)instanceOf.getExpression());
                    }
                }
                return false;
            }
        });
    }

    @Generated
    public RemoveRedundantNullCheckBeforeInstanceof() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public String toString() {
        return "RemoveRedundantNullCheckBeforeInstanceof(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantNullCheckBeforeInstanceof)) {
            return false;
        }
        RemoveRedundantNullCheckBeforeInstanceof other = (RemoveRedundantNullCheckBeforeInstanceof)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveRedundantNullCheckBeforeInstanceof;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

