/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class PreferEqualityComparisonOverDifferenceCheck
extends Recipe {
    final String displayName = "Prefer direct comparison of numbers";
    final String description = "Replace `a - b == 0` with `a == b`, `a - b != 0` with `a != b`, `a - b < 0` with `a < b`, and similar transformations for all comparison operators to improve readability and avoid overflow issues.";

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.Binary.Type operator = (binary = super.visitBinary(binary, (Object)ctx)).getOperator();
                if (this.isComparisonOperator(operator)) {
                    Expression unwrappedLeft = this.unwrapParentheses(binary.getLeft());
                    Expression unwrappedRight = this.unwrapParentheses(binary.getRight());
                    if (this.isSubtraction(unwrappedLeft) && this.isZero(unwrappedRight)) {
                        J.Binary subtraction = (J.Binary)unwrappedLeft;
                        return this.transformToEquality(binary, subtraction, ctx);
                    }
                }
                return binary;
            }

            private boolean isComparisonOperator(J.Binary.Type operator) {
                return operator == J.Binary.Type.Equal || operator == J.Binary.Type.NotEqual || operator == J.Binary.Type.LessThan || operator == J.Binary.Type.LessThanOrEqual || operator == J.Binary.Type.GreaterThan || operator == J.Binary.Type.GreaterThanOrEqual;
            }

            private Expression unwrapParentheses(Expression expr) {
                while (expr instanceof J.Parentheses) {
                    J.Parentheses parentheses = (J.Parentheses)expr;
                    expr = (Expression)parentheses.getTree();
                }
                return expr;
            }

            private boolean isSubtraction(Expression expr) {
                return expr instanceof J.Binary && ((J.Binary)expr).getOperator() == J.Binary.Type.Subtraction;
            }

            private boolean isZero(Expression expr) {
                Object value;
                if (expr instanceof J.Literal && (value = ((J.Literal)expr).getValue()) instanceof Number) {
                    return ((Number)value).doubleValue() == 0.0;
                }
                return false;
            }

            private J.Binary transformToEquality(J.Binary original, J.Binary subtraction, ExecutionContext ctx) {
                return (J.Binary)this.maybeAutoFormat((J)original, (J)original.withLeft(subtraction.getLeft()).withRight(subtraction.getRight()), ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

