/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NamingService;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class MethodNameCasing
extends ScanningRecipe<List<MethodNameChange>> {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false)
    private final @Nullable Boolean includeTestSources;
    @Option(displayName="Rename public methods", description="Changes are not applied to public methods unless specified.", required=false)
    private final @Nullable Boolean renamePublicMethods;
    private final String displayName = "Standardize method name casing";
    private final String description = "Fixes method names that do not follow standard naming conventions. For example, `String getFoo_bar()` would be adjusted to `String getFooBar()` and `int DoSomething()` would be adjusted to `int doSomething()`.";
    private final Set<String> tags = Collections.singleton("RSPEC-S100");

    public List<MethodNameChange> getInitialValue(ExecutionContext ctx) {
        return new ArrayList<MethodNameChange>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final List<MethodNameChange> changes) {
        return new JavaIsoVisitor<ExecutionContext>(){
            UUID scope;

            public J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    this.scope = tree.getId();
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                    if (!sourceSet.isPresent()) {
                        this.stopAfterPreVisit();
                    } else if (!Boolean.TRUE.equals(MethodNameCasing.this.includeTestSources) && !"main".equals(((JavaSourceSet)sourceSet.get()).getName())) {
                        this.stopAfterPreVisit();
                    }
                }
                return (J)super.preVisit((Tree)tree, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass == null || enclosingClass.getKind() != J.ClassDeclaration.Kind.Type.Class) {
                    return method;
                }
                String simpleName = method.getSimpleName();
                if (this.containsValidModifiers(method) && method.getMethodType() != null && enclosingClass.getType() != null && !method.isConstructor()) {
                    String normalized = VariableNameUtils.normalizeName((String)simpleName);
                    NamingService service = (NamingService)this.service(NamingService.class);
                    String toName = service.standardizeMethodName(normalized);
                    if (!(StringUtils.isBlank((String)toName) || toName.equals(simpleName) || StringUtils.isNumeric((String)toName) || this.methodExists(method.getMethodType(), toName))) {
                        changes.add(new MethodNameChange(this.scope, method.hasModifier(J.Modifier.Type.Private), new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)method), toName, Boolean.valueOf(false), Boolean.valueOf(false))));
                    }
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private boolean containsValidModifiers(J.MethodDeclaration method) {
                return !method.hasModifier(J.Modifier.Type.Public) || Boolean.TRUE.equals(MethodNameCasing.this.renamePublicMethods);
            }

            private boolean methodExists(JavaType.Method method, String newName) {
                return TypeUtils.findDeclaredMethod((JavaType.FullyQualified)method.getDeclaringType(), (String)newName, (List)method.getParameterTypes()).isPresent();
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final List<MethodNameChange> changes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    for (MethodNameChange nameChange : changes) {
                        if (nameChange.isPrivateMethod() && !tree.getId().equals(nameChange.getScope())) continue;
                        cu = (JavaSourceFile)nameChange.getRecipe().getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                    }
                    return cu;
                }
                return (J)tree;
            }
        };
    }

    @Generated
    public MethodNameCasing(@Nullable Boolean includeTestSources, @Nullable Boolean renamePublicMethods) {
        this.includeTestSources = includeTestSources;
        this.renamePublicMethods = renamePublicMethods;
    }

    @Generated
    public @Nullable Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @Generated
    public @Nullable Boolean getRenamePublicMethods() {
        return this.renamePublicMethods;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String toString() {
        return "MethodNameCasing(includeTestSources=" + this.getIncludeTestSources() + ", renamePublicMethods=" + this.getRenamePublicMethods() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodNameCasing)) {
            return false;
        }
        MethodNameCasing other = (MethodNameCasing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        if (this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources)) {
            return false;
        }
        Boolean this$renamePublicMethods = this.getRenamePublicMethods();
        Boolean other$renamePublicMethods = other.getRenamePublicMethods();
        if (this$renamePublicMethods == null ? other$renamePublicMethods != null : !((Object)this$renamePublicMethods).equals(other$renamePublicMethods)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodNameCasing;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        Boolean $renamePublicMethods = this.getRenamePublicMethods();
        result = result * 59 + ($renamePublicMethods == null ? 43 : ((Object)$renamePublicMethods).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public static final class MethodNameChange {
        private final UUID scope;
        private final boolean privateMethod;
        private final ChangeMethodName recipe;

        @Generated
        public MethodNameChange(UUID scope, boolean privateMethod, ChangeMethodName recipe) {
            this.scope = scope;
            this.privateMethod = privateMethod;
            this.recipe = recipe;
        }

        @Generated
        public UUID getScope() {
            return this.scope;
        }

        @Generated
        public boolean isPrivateMethod() {
            return this.privateMethod;
        }

        @Generated
        public ChangeMethodName getRecipe() {
            return this.recipe;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodNameChange)) {
                return false;
            }
            MethodNameChange other = (MethodNameChange)o;
            if (this.isPrivateMethod() != other.isPrivateMethod()) {
                return false;
            }
            UUID this$scope = this.getScope();
            UUID other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
                return false;
            }
            ChangeMethodName this$recipe = this.getRecipe();
            ChangeMethodName other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrivateMethod() ? 79 : 97);
            UUID $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            ChangeMethodName $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MethodNameCasing.MethodNameChange(scope=" + this.getScope() + ", privateMethod=" + this.isPrivateMethod() + ", recipe=" + this.getRecipe() + ")";
        }
    }
}

