/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.JavaVarKeyword;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

@Incubating(since="7.36.0")
public final class InstanceOfPatternMatch
extends Recipe {
    private final String displayName = "Changes code to use Java 17's `instanceof` pattern matching";
    private final String description = "Adds pattern variables to `instanceof` expressions wherever the same (side effect free) expression is referenced in a corresponding type cast expression within the flow scope of the `instanceof`. Currently, this recipe supports `if` statements and ternary operator expressions.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), Preconditions.not(new KotlinFileChecker()), Preconditions.not(new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J postVisit(J tree, ExecutionContext ctx) {
                J result = (J)super.postVisit((Tree)tree, (Object)ctx);
                InstanceOfPatternReplacements original = (InstanceOfPatternReplacements)this.getCursor().getMessage("flowTypeScope");
                if (original != null && !original.isEmpty()) {
                    return UseInstanceOfPatternMatching.refactor(result, original, this.getCursor().getParentOrThrow());
                }
                return result;
            }

            public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
                if ((instanceOf = (J.InstanceOf)super.visitInstanceOf(instanceOf, (Object)ctx)).getPattern() != null || !instanceOf.getSideEffects().isEmpty()) {
                    return instanceOf;
                }
                Cursor maybeReplacementRoot = null;
                J.Binary additionalContext = null;
                boolean flowScopeBreakEncountered = false;
                Iterator it = this.getCursor().getPathAsCursors();
                while (it.hasNext()) {
                    Cursor next = (Cursor)it.next();
                    Object value = next.getValue();
                    if (value instanceof J.Binary) {
                        J.Binary binary = (J.Binary)value;
                        if (!flowScopeBreakEncountered && binary.getOperator() == J.Binary.Type.And) {
                            additionalContext = binary;
                            continue;
                        }
                        flowScopeBreakEncountered = true;
                        continue;
                    }
                    if (value instanceof J.Unary && ((J.Unary)value).getOperator() == J.Unary.Type.Not) {
                        flowScopeBreakEncountered = true;
                        continue;
                    }
                    if (!(value instanceof Statement)) continue;
                    maybeReplacementRoot = next;
                    break;
                }
                if (maybeReplacementRoot != null) {
                    J root = (J)maybeReplacementRoot.getValue();
                    HashSet<J> contexts = new HashSet<J>();
                    if (!flowScopeBreakEncountered) {
                        if (root instanceof J.If) {
                            contexts.add((J)((J.If)root).getThenPart());
                        } else if (root instanceof J.Ternary) {
                            contexts.add((J)((J.Ternary)root).getTruePart());
                        }
                    }
                    if (additionalContext != null) {
                        contexts.add((J)additionalContext);
                    }
                    if (!contexts.isEmpty()) {
                        InstanceOfPatternReplacements replacements = (InstanceOfPatternReplacements)maybeReplacementRoot.computeMessageIfAbsent("flowTypeScope", k -> new InstanceOfPatternReplacements(root));
                        replacements.registerInstanceOf(instanceOf, contexts);
                    }
                }
                return instanceOf;
            }

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                InstanceOfPatternReplacements replacements;
                J result = super.visitTypeCast(typeCast, (Object)ctx);
                if (result instanceof J.TypeCast && (replacements = (InstanceOfPatternReplacements)this.getCursor().getNearestMessage("flowTypeScope")) != null) {
                    replacements.registerTypeCast((J.TypeCast)result, this.getCursor());
                }
                return result;
            }
        });
    }

    @Generated
    public InstanceOfPatternMatch() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public String toString() {
        return "InstanceOfPatternMatch(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceOfPatternMatch)) {
            return false;
        }
        InstanceOfPatternMatch other = (InstanceOfPatternMatch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceOfPatternMatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }

    private static class VariableNameStrategy {
        public static final Pattern NAME_SPLIT_PATTERN = Pattern.compile("[$._]*(?=\\p{Upper}+[\\p{Lower}\\p{Digit}]*)");
        private final Style style;
        private final @Nullable String name;
        private final Set<Cursor> contextScopes;

        private VariableNameStrategy(Style style, @Nullable String exactName, Set<Cursor> contextScopes) {
            this.style = style;
            this.name = exactName;
            this.contextScopes = contextScopes;
        }

        static VariableNameStrategy short_() {
            return new VariableNameStrategy(Style.SHORT, null, Collections.emptySet());
        }

        static VariableNameStrategy normal(Set<Cursor> contextScopes) {
            return new VariableNameStrategy(Style.NORMAL, null, contextScopes);
        }

        static VariableNameStrategy exact(String name) {
            return new VariableNameStrategy(Style.EXACT, name, Collections.emptySet());
        }

        public String variableName(@Nullable JavaType type) {
            if (this.style == Style.EXACT) {
                return this.name;
            }
            if (type instanceof JavaType.FullyQualified) {
                String className = ((JavaType.FullyQualified)type).getClassName();
                className = className.substring(className.lastIndexOf(46) + 1);
                String baseName = null;
                switch (this.style.ordinal()) {
                    case 0: {
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < className.length(); ++i) {
                            char c2 = className.charAt(i);
                            if (!Character.isUpperCase(c2)) continue;
                            builder.append(Character.toLowerCase(c2));
                        }
                        baseName = builder.length() > 0 ? builder.toString() : "o";
                        break;
                    }
                    case 1: {
                        Set namesInScope = this.contextScopes.stream().flatMap(c -> VariableNameUtils.findNamesInScope((Cursor)c).stream()).collect(Collectors.toSet());
                        List nameSegments = Stream.of(NAME_SPLIT_PATTERN.split(className)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                        for (int i = nameSegments.size() - 1; i >= 0; --i) {
                            String name = String.join((CharSequence)"", nameSegments.subList(i, nameSegments.size()));
                            if (name.length() < 2 || namesInScope.contains(name = Character.toLowerCase(name.charAt(0)) + name.substring(1))) continue;
                            baseName = name;
                            break;
                        }
                        if (baseName != null) break;
                        baseName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
                        break;
                    }
                    default: {
                        baseName = "obj";
                    }
                }
                String candidate = baseName;
                block6: while (true) {
                    for (Cursor scope : this.contextScopes) {
                        String newCandidate = VariableNameUtils.generateVariableName((String)candidate, (Cursor)scope, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                        if (newCandidate.equals(candidate)) continue;
                        candidate = newCandidate;
                        continue block6;
                    }
                    break;
                }
                return candidate;
            }
            if (type instanceof JavaType.Primitive) {
                String keyword = ((JavaType.Primitive)type).getKeyword();
                return this.style == Style.SHORT ? keyword.substring(0, 1) : keyword;
            }
            if (type instanceof JavaType.Array) {
                JavaType elemType = ((JavaType.Array)type).getElemType();
                while (elemType instanceof JavaType.Array) {
                    elemType = ((JavaType.Array)elemType).getElemType();
                }
                return this.variableName(elemType) + 's';
            }
            return this.style == Style.SHORT ? "o" : "obj";
        }

        static enum Style {
            SHORT,
            NORMAL,
            EXACT;

        }
    }

    private static class UseInstanceOfPatternMatching
    extends JavaVisitor<Integer> {
        private final InstanceOfPatternReplacements replacements;

        public UseInstanceOfPatternMatching(InstanceOfPatternReplacements replacements) {
            this.replacements = replacements;
        }

        static @Nullable J refactor(@Nullable J tree, InstanceOfPatternReplacements replacements, Cursor cursor) {
            return (J)new UseInstanceOfPatternMatching(replacements).visit((Tree)tree, 0, cursor);
        }

        public J visitBinary(J.Binary binary, Integer p) {
            J.Binary b = binary.withLeft((Expression)this.visitNonNull((Tree)binary.getLeft(), p));
            if (b.getLeft() != binary.getLeft()) {
                J.InstanceOf newRight;
                J.InstanceOf leftInstanceOf;
                Cursor widenedCursor = this.updateCursor((Tree)b);
                HashSet<String> usedNames = new HashSet<String>();
                if (b.getLeft() instanceof J.InstanceOf && (leftInstanceOf = (J.InstanceOf)b.getLeft()).getPattern() != null) {
                    usedNames.add(((J.Identifier)leftInstanceOf.getPattern()).getSimpleName());
                }
                if (binary.getRight() instanceof J.InstanceOf) {
                    newRight = this.replacements.processInstanceOf((J.InstanceOf)binary.getRight(), widenedCursor, usedNames);
                } else if (binary.getRight() instanceof J.Parentheses && ((J.Parentheses)binary.getRight()).getTree() instanceof J.InstanceOf) {
                    J.Parentheses originalRight = (J.Parentheses)binary.getRight();
                    newRight = originalRight.withTree((J)this.replacements.processInstanceOf((J.InstanceOf)originalRight.getTree(), widenedCursor, usedNames));
                } else {
                    newRight = (Expression)this.visitNonNull((Tree)binary.getRight(), p, widenedCursor);
                }
                return b.withRight((Expression)newRight);
            }
            return b.withRight((Expression)this.visitNonNull((Tree)binary.getRight(), p));
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, Integer p) {
            instanceOf = (J.InstanceOf)super.visitInstanceOf(instanceOf, (Object)p);
            return this.replacements.processInstanceOf(instanceOf, this.getCursor(), new HashSet<String>());
        }

        public <T extends J> J visitParentheses(J.Parentheses<T> parens, Integer p) {
            J replacement;
            if (parens.getTree() instanceof J.TypeCast && (replacement = this.replacements.processTypeCast((J.TypeCast)parens.getTree(), this.getCursor())) != null) {
                return replacement.withPrefix(parens.getPrefix());
            }
            return super.visitParentheses(parens, (Object)p);
        }

        public J visitTypeCast(J.TypeCast typeCast, Integer p) {
            J replacement = this.replacements.processTypeCast(typeCast = (J.TypeCast)super.visitTypeCast(typeCast, (Object)p), this.getCursor());
            if (replacement != null) {
                return replacement;
            }
            return typeCast;
        }

        public @Nullable J visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer p) {
            multiVariable = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)p);
            return this.replacements.processVariableDeclarations(multiVariable);
        }
    }

    private static class InstanceOfPatternReplacements {
        private final J root;
        private final Map<ExpressionAndType, J.InstanceOf> instanceOfs = new HashMap<ExpressionAndType, J.InstanceOf>();
        private final Map<J.InstanceOf, Set<J>> contexts = new HashMap<J.InstanceOf, Set<J>>();
        private final Map<J.InstanceOf, Set<Cursor>> contextScopes = new HashMap<J.InstanceOf, Set<Cursor>>();
        private final Map<J.TypeCast, J.InstanceOf> replacements = new HashMap<J.TypeCast, J.InstanceOf>();
        private final Map<J.InstanceOf, VariableAndTypeTree> variablesToDelete = new HashMap<J.InstanceOf, VariableAndTypeTree>();

        public void registerInstanceOf(J.InstanceOf instanceOf, Set<J> contexts) {
            Expression expression = instanceOf.getExpression();
            JavaType type = ((TypedTree)instanceOf.getClazz()).getType();
            if (type == null) {
                return;
            }
            Optional<ExpressionAndType> existing = this.instanceOfs.keySet().stream().filter(k -> TypeUtils.isAssignableTo((JavaType)type, (JavaType)k.getType()) && SemanticallyEqual.areEqual((J)k.getExpression(), (J)expression)).findAny();
            if (!existing.isPresent()) {
                this.instanceOfs.put(new ExpressionAndType(expression, type), instanceOf);
                this.contexts.put(instanceOf, contexts);
            }
        }

        public void registerTypeCast(J.TypeCast typeCast, Cursor cursor) {
            Expression expression = typeCast.getExpression();
            JavaType castType = ((TypeTree)typeCast.getClazz().getTree()).getType();
            Optional<ExpressionAndType> match = this.instanceOfs.keySet().stream().filter(k -> this.hasSameRawType(castType, k.getType()) && this.isCheckedCastCompatible(castType) && SemanticallyEqual.areEqual((J)k.getExpression(), (J)expression)).findAny();
            if (match.isPresent()) {
                Cursor parent = cursor.getParentTreeCursor();
                J.InstanceOf instanceOf = this.instanceOfs.get(match.get());
                Set<J> validContexts = this.contexts.get(instanceOf);
                Iterator it = cursor.getPath();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (validContexts.contains(next)) {
                        if (this.isAcceptableTypeCast(typeCast.getType()) && this.isTheSameAsOtherTypeCasts(typeCast, instanceOf) && this.isAcceptableParentTypeCast(parent)) {
                            if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable && !this.variablesToDelete.containsKey(instanceOf)) {
                                this.variablesToDelete.put(instanceOf, new VariableAndTypeTree((J.VariableDeclarations.NamedVariable)parent.getValue(), Objects.requireNonNull(Objects.requireNonNull((J.VariableDeclarations)parent.firstEnclosing(J.VariableDeclarations.class)).getTypeExpression())));
                            } else {
                                this.replacements.put(typeCast, instanceOf);
                            }
                            this.contextScopes.computeIfAbsent(instanceOf, k -> new HashSet()).add(cursor);
                            break;
                        }
                        this.replacements.entrySet().removeIf(e -> e.getValue() == instanceOf);
                        this.variablesToDelete.remove(instanceOf);
                        this.contextScopes.remove(instanceOf);
                        this.contexts.remove(instanceOf);
                        this.instanceOfs.entrySet().removeIf(e -> e.getValue() == instanceOf);
                        break;
                    }
                    if (this.root != next) continue;
                    break;
                }
            }
        }

        private boolean hasSameRawType(JavaType firstType, JavaType secondType) {
            JavaType secondRawType;
            JavaType firstRawType = this.getRawType(firstType);
            return TypeUtils.isAssignableTo((JavaType)firstRawType, (JavaType)(secondRawType = this.getRawType(secondType))) && TypeUtils.isAssignableTo((JavaType)secondRawType, (JavaType)firstRawType);
        }

        private JavaType getRawType(JavaType type) {
            if (type instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)type).getType();
            }
            return type;
        }

        private boolean isCheckedCastCompatible(JavaType castType) {
            if (!(castType instanceof JavaType.Parameterized)) {
                return true;
            }
            JavaType.Parameterized parameterizedCastTargetType = (JavaType.Parameterized)castType;
            return parameterizedCastTargetType.getTypeParameters().stream().allMatch(typeParameter -> {
                if (!(typeParameter instanceof JavaType.GenericTypeVariable)) {
                    return false;
                }
                JavaType.GenericTypeVariable genericTypeVariable = (JavaType.GenericTypeVariable)typeParameter;
                return genericTypeVariable.getBounds().isEmpty() && "?".equals(genericTypeVariable.getName());
            });
        }

        private boolean isAcceptableTypeCast(JavaType type) {
            if (type instanceof JavaType.Parameterized) {
                return Objects.requireNonNull(((JavaType.Parameterized)type).getTypeParameters()).stream().allMatch(JavaType.GenericTypeVariable.class::isInstance);
            }
            return true;
        }

        private boolean isAcceptableParentTypeCast(Cursor parent) {
            if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                return this.isAcceptableTypeCast(Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)parent.getValue()).getType()));
            }
            return true;
        }

        private boolean isTheSameAsOtherTypeCasts(J.TypeCast typeCast, J.InstanceOf instanceOf) {
            return this.replacements.entrySet().stream().filter(e -> e.getValue() == instanceOf).findFirst().map(e -> ((J.TypeCast)e.getKey()).getType().equals((Object)typeCast.getType())).orElse(true);
        }

        public boolean isEmpty() {
            return this.replacements.isEmpty() && this.variablesToDelete.isEmpty();
        }

        public J.InstanceOf processInstanceOf(J.InstanceOf instanceOf, Cursor cursor, Set<String> usedNames) {
            if (!this.contextScopes.containsKey(instanceOf)) {
                return instanceOf;
            }
            String name = this.patternVariableName(instanceOf, cursor, usedNames);
            TypeTree typeCastTypeTree = this.computeTypeTreeFromTypeCasts(instanceOf);
            TypedTree currentTypeTree = (TypedTree)instanceOf.getClazz();
            if (typeCastTypeTree.getType() instanceof JavaType.Primitive || typeCastTypeTree.getMarkers().findFirst(JavaVarKeyword.class).isPresent()) {
                typeCastTypeTree = currentTypeTree;
            }
            J.InstanceOf result = instanceOf.withPattern((J)new J.Identifier(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, Collections.emptyList(), name, typeCastTypeTree.getType(), null)).withClazz((J)typeCastTypeTree.withPrefix(currentTypeTree.getPrefix()).withId(Tree.randomId()));
            for (Map.Entry<J.TypeCast, J.InstanceOf> entry : this.replacements.entrySet()) {
                if (entry.getValue() != instanceOf) continue;
                entry.setValue(result);
            }
            return result;
        }

        private TypeTree computeTypeTreeFromTypeCasts(J.InstanceOf instanceOf) {
            VariableAndTypeTree variable;
            TypeTree typeCastTypeTree = this.replacements.entrySet().stream().filter(e -> e.getValue() == instanceOf).findFirst().map(e -> (TypeTree)((J.TypeCast)e.getKey()).getClazz().getTree()).orElse(null);
            if (typeCastTypeTree == null && (variable = this.variablesToDelete.get(instanceOf)) != null) {
                typeCastTypeTree = variable.getType();
            }
            return typeCastTypeTree;
        }

        private String patternVariableName(J.InstanceOf instanceOf, Cursor cursor, Set<String> usedNames) {
            VariableNameStrategy strategy;
            JavaType type = ((TypeTree)instanceOf.getClazz()).getType();
            if (this.root instanceof J.If) {
                VariableAndTypeTree variableData = this.variablesToDelete.get(instanceOf);
                if (variableData != null) {
                    return VariableNameStrategy.exact(variableData.getVariable().getSimpleName()).variableName(type);
                }
                strategy = VariableNameStrategy.normal(this.contextScopes.get(instanceOf));
            } else {
                strategy = VariableNameStrategy.short_();
            }
            String baseName = strategy.variableName(type);
            if (this.root instanceof J.If) {
                J.If enclosingIf = (J.If)cursor.firstEnclosing(J.If.class);
                String nameInIfScope = VariableNameUtils.generateVariableName((String)baseName, (Cursor)new Cursor(cursor, (Object)enclosingIf), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                while (usedNames.contains(nameInIfScope)) {
                    String numStr = nameInIfScope.substring(baseName.length());
                    nameInIfScope = baseName + (numStr.isEmpty() ? 1 : Integer.parseInt(numStr) + 1);
                }
                String nameInCursorScope = VariableNameUtils.generateVariableName((String)baseName, (Cursor)cursor, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                return nameInIfScope.compareTo(nameInCursorScope) >= 0 ? nameInIfScope : nameInCursorScope;
            }
            return VariableNameUtils.generateVariableName((String)baseName, (Cursor)cursor, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
        }

        public @Nullable J processTypeCast(J.TypeCast typeCast, Cursor cursor) {
            J.InstanceOf instanceOf = this.replacements.get(typeCast);
            if (instanceOf != null && instanceOf.getPattern() != null) {
                String name = ((J.Identifier)instanceOf.getPattern()).getSimpleName();
                TypedTree owner = (TypedTree)cursor.firstEnclosing(J.MethodDeclaration.class);
                owner = owner != null ? owner : (TypedTree)cursor.firstEnclosingOrThrow(J.ClassDeclaration.class);
                JavaType.Variable fieldType = new JavaType.Variable(null, Flag.Default.getBitMask(), name, owner.getType(), typeCast.getType(), Collections.emptyList());
                return new J.Identifier(Tree.randomId(), typeCast.getPrefix(), Markers.EMPTY, Collections.emptyList(), name, typeCast.getType(), fieldType);
            }
            return null;
        }

        public @Nullable J processVariableDeclarations(J.VariableDeclarations multiVariable) {
            return multiVariable.getVariables().stream().anyMatch(v -> this.variablesToDelete.values().stream().anyMatch(vd -> vd.getVariable() == v)) ? null : multiVariable;
        }

        @Generated
        public InstanceOfPatternReplacements(J root) {
            this.root = root;
        }

        @Generated
        public J getRoot() {
            return this.root;
        }

        @Generated
        public Map<ExpressionAndType, J.InstanceOf> getInstanceOfs() {
            return this.instanceOfs;
        }

        @Generated
        public Map<J.InstanceOf, Set<J>> getContexts() {
            return this.contexts;
        }

        @Generated
        public Map<J.InstanceOf, Set<Cursor>> getContextScopes() {
            return this.contextScopes;
        }

        @Generated
        public Map<J.TypeCast, J.InstanceOf> getReplacements() {
            return this.replacements;
        }

        @Generated
        public Map<J.InstanceOf, VariableAndTypeTree> getVariablesToDelete() {
            return this.variablesToDelete;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOfPatternReplacements)) {
                return false;
            }
            InstanceOfPatternReplacements other = (InstanceOfPatternReplacements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            J this$root = this.getRoot();
            J other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            Map<ExpressionAndType, J.InstanceOf> this$instanceOfs = this.getInstanceOfs();
            Map<ExpressionAndType, J.InstanceOf> other$instanceOfs = other.getInstanceOfs();
            if (this$instanceOfs == null ? other$instanceOfs != null : !((Object)this$instanceOfs).equals(other$instanceOfs)) {
                return false;
            }
            Map<J.InstanceOf, Set<J>> this$contexts = this.getContexts();
            Map<J.InstanceOf, Set<J>> other$contexts = other.getContexts();
            if (this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts)) {
                return false;
            }
            Map<J.InstanceOf, Set<Cursor>> this$contextScopes = this.getContextScopes();
            Map<J.InstanceOf, Set<Cursor>> other$contextScopes = other.getContextScopes();
            if (this$contextScopes == null ? other$contextScopes != null : !((Object)this$contextScopes).equals(other$contextScopes)) {
                return false;
            }
            Map<J.TypeCast, J.InstanceOf> this$replacements = this.getReplacements();
            Map<J.TypeCast, J.InstanceOf> other$replacements = other.getReplacements();
            if (this$replacements == null ? other$replacements != null : !((Object)this$replacements).equals(other$replacements)) {
                return false;
            }
            Map<J.InstanceOf, VariableAndTypeTree> this$variablesToDelete = this.getVariablesToDelete();
            Map<J.InstanceOf, VariableAndTypeTree> other$variablesToDelete = other.getVariablesToDelete();
            return !(this$variablesToDelete == null ? other$variablesToDelete != null : !((Object)this$variablesToDelete).equals(other$variablesToDelete));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InstanceOfPatternReplacements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            Map<ExpressionAndType, J.InstanceOf> $instanceOfs = this.getInstanceOfs();
            result = result * 59 + ($instanceOfs == null ? 43 : ((Object)$instanceOfs).hashCode());
            Map<J.InstanceOf, Set<J>> $contexts = this.getContexts();
            result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
            Map<J.InstanceOf, Set<Cursor>> $contextScopes = this.getContextScopes();
            result = result * 59 + ($contextScopes == null ? 43 : ((Object)$contextScopes).hashCode());
            Map<J.TypeCast, J.InstanceOf> $replacements = this.getReplacements();
            result = result * 59 + ($replacements == null ? 43 : ((Object)$replacements).hashCode());
            Map<J.InstanceOf, VariableAndTypeTree> $variablesToDelete = this.getVariablesToDelete();
            result = result * 59 + ($variablesToDelete == null ? 43 : ((Object)$variablesToDelete).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InstanceOfPatternMatch.InstanceOfPatternReplacements(root=" + this.getRoot() + ", instanceOfs=" + this.getInstanceOfs() + ", contexts=" + this.getContexts() + ", contextScopes=" + this.getContextScopes() + ", replacements=" + this.getReplacements() + ", variablesToDelete=" + this.getVariablesToDelete() + ")";
        }
    }

    private static class VariableAndTypeTree {
        private final J.VariableDeclarations.NamedVariable variable;
        private final TypeTree type;

        @Generated
        public VariableAndTypeTree(J.VariableDeclarations.NamedVariable variable, TypeTree type) {
            this.variable = variable;
            this.type = type;
        }

        @Generated
        public J.VariableDeclarations.NamedVariable getVariable() {
            return this.variable;
        }

        @Generated
        public TypeTree getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableAndTypeTree)) {
                return false;
            }
            VariableAndTypeTree other = (VariableAndTypeTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            J.VariableDeclarations.NamedVariable this$variable = this.getVariable();
            J.VariableDeclarations.NamedVariable other$variable = other.getVariable();
            if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
                return false;
            }
            TypeTree this$type = this.getType();
            TypeTree other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VariableAndTypeTree;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.VariableDeclarations.NamedVariable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            TypeTree $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InstanceOfPatternMatch.VariableAndTypeTree(variable=" + this.getVariable() + ", type=" + this.getType() + ")";
        }
    }

    private static class ExpressionAndType {
        private final Expression expression;
        private final JavaType type;

        @Generated
        public ExpressionAndType(Expression expression, JavaType type) {
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionAndType)) {
                return false;
            }
            ExpressionAndType other = (ExpressionAndType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExpressionAndType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InstanceOfPatternMatch.ExpressionAndType(expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }
    }
}

