/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;

public class CompareEnumsWithEqualityOperator
extends Recipe {
    final String displayName = "Enum values should be compared with \"==\"";
    final String description = "Replaces `Enum equals(java.lang.Object)` with `Enum == java.lang.Object`. An `!Enum equals(java.lang.Object)` will change to `!=`.";
    final Set<String> tags = Collections.singleton("RSPEC-S4551");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher enumEquals = new MethodMatcher("java.lang.Enum equals(java.lang.Object)");
        return Preconditions.check((TreeVisitor)new UsesMethod(enumEquals), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (enumEquals.matches((MethodCall)m) && m.getSelect() != null) {
                    Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.Unary || is instanceof J.Block || is instanceof J.Binary || is instanceof J.Ternary || is instanceof J.Lambda);
                    boolean isNot = parent.getValue() instanceof J.Unary && ((J.Unary)parent.getValue()).getOperator() == J.Unary.Type.Not;
                    boolean needsParentheses = false;
                    if (isNot) {
                        parent.putMessage("REMOVE_UNARY_NOT", parent.getValue());
                    } else if (parent.getValue() instanceof J.Binary) {
                        J.Binary binary = (J.Binary)parent.getValue();
                        J.Binary.Type op = binary.getOperator();
                        needsParentheses = op == J.Binary.Type.Equal || op == J.Binary.Type.NotEqual;
                    }
                    String code = "#{any()} " + (isNot ? "!=" : "==") + " #{any()}";
                    return JavaTemplate.apply((String)(needsParentheses ? "(" + code + ")" : code), (Cursor)this.updateCursor((Tree)m), (JavaCoordinates)m.getCoordinates().replace(), (Object[])new Object[]{m.getSelect(), m.getArguments().get(0)});
                }
                return m;
            }

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J j = super.visitUnary(unary, (Object)ctx);
                J.Unary asUnary = (J.Unary)j;
                if (asUnary.equals(this.getCursor().pollMessage("REMOVE_UNARY_NOT"))) {
                    return asUnary.getExpression().unwrap().withPrefix(asUnary.getPrefix());
                }
                return j;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

