/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class AtomicPrimitiveEqualsUsesGet
extends Recipe {
    public static final String ATOMIC_ATOMIC_BOOLEAN = "java.util.concurrent.atomic.AtomicBoolean";
    public static final String ATOMIC_ATOMIC_INTEGER = "java.util.concurrent.atomic.AtomicInteger";
    public static final String ATOMIC_ATOMIC_LONG = "java.util.concurrent.atomic.AtomicLong";
    private static final List<String> ATOMIC_PRIMITIVE_TYPES = Arrays.asList("java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong");
    final String displayName = "Atomic Boolean, Integer, and Long equality checks compare their values";
    final String description = "`AtomicBoolean#equals(Object)`, `AtomicInteger#equals(Object)` and `AtomicLong#equals(Object)` are only equal to their instance. This recipe converts `a.equals(b)` to `a.get() == b.get()`.";
    final Set<String> tags = Collections.singleton("RSPEC-S2204");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(ATOMIC_ATOMIC_BOOLEAN, Boolean.valueOf(false)), new UsesType(ATOMIC_ATOMIC_INTEGER, Boolean.valueOf(false)), new UsesType(ATOMIC_ATOMIC_LONG, Boolean.valueOf(false))}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher aiMethodMatcher = new MethodMatcher("java.lang.Object equals(java.lang.Object)");

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.FullyQualified fqt;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (mi.getSelect() != null && this.isAtomicEqualsType(mi.getSelect().getType()) && this.aiMethodMatcher.matches((MethodCall)mi) && TypeUtils.isOfType((JavaType)mi.getSelect().getType(), (JavaType)((Expression)mi.getArguments().get(0)).getType()) && (fqt = TypeUtils.asFullyQualified((JavaType)mi.getSelect().getType())) != null) {
                    String templateString = "#{any(" + fqt.getFullyQualifiedName() + ")}.get() == #{any(" + fqt.getFullyQualifiedName() + ")}.get()";
                    return JavaTemplate.builder((String)templateString).imports(new String[]{fqt.getFullyQualifiedName()}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)});
                }
                return mi;
            }

            private boolean isAtomicEqualsType(@Nullable JavaType type) {
                return type instanceof JavaType.FullyQualified && ATOMIC_PRIMITIVE_TYPES.contains(((JavaType.FullyQualified)type).getFullyQualifiedName());
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

