/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;

public class WriteOctalValuesAsDecimal
extends Recipe {
    final String displayName = "Write octal values as decimal";
    final String description = "Developers may not recognize octal values as such, mistaking them instead for decimal values.";
    final Set<String> tags = Collections.singleton("RSPEC-S1314");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new CSharpFileChecker()), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
                String src = literal.getValueSource();
                if (src != null && src.startsWith("0") && src.length() >= 2 && src.charAt(1) != 'x' && src.charAt(1) != 'X' && src.charAt(1) != 'b' && src.charAt(1) != 'B' && src.charAt(1) != '.' && src.charAt(src.length() - 1) != 'L' && src.charAt(src.length() - 1) != 'l' && src.charAt(src.length() - 1) != 'F' && src.charAt(src.length() - 1) != 'f' && src.charAt(src.length() - 1) != 'D' && src.charAt(src.length() - 1) != 'd' && !src.contains(".")) {
                    assert (literal.getValue() != null);
                    return literal.withValueSource(literal.getValue().toString());
                }
                return super.visitLiteral(literal, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

