/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UseStringReplace
extends Recipe {
    final String displayName = "Use `String::replace()` when first parameter is not a real regular expression";
    final String description = "When `String::replaceAll` is used, the first argument should be a real regular expression. If it\u2019s not the case, `String::replace` does exactly the same thing as `String::replaceAll` without the performance drawback of the regex.";
    final Set<String> tags = Collections.singleton("RSPEC-S5361");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseStringReplaceVisitor();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    private static class UseStringReplaceVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final MethodMatcher REPLACE_ALL = new MethodMatcher("java.lang.String replaceAll(..)");
        private static final Pattern ESCAPED_CHARACTER = Pattern.compile("\\\\\\.");
        private static final Pattern METACHARACTERS = Pattern.compile("[(\\[{\\\\^\\-$!|\\]})?*+.]|\\?=|<=");
        private static final Pattern CHARACTER_CLASSES = Pattern.compile("\\\\d|\\\\D|\\\\s|\\\\S|\\\\w|\\\\W");

        private UseStringReplaceVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation invocation = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            if (REPLACE_ALL.matches((MethodCall)invocation)) {
                String firstValue;
                Expression secondArgument = (Expression)invocation.getArguments().get(1);
                if (!this.isStringLiteral(secondArgument)) {
                    return invocation;
                }
                String secondValue = (String)((J.Literal)secondArgument).getValue();
                if (secondValue != null && (secondValue.contains("$") || secondValue.contains("\\"))) {
                    return invocation;
                }
                Expression firstArgument = (Expression)invocation.getArguments().get(0);
                if (this.isStringLiteral(firstArgument) && (firstValue = (String)((J.Literal)firstArgument).getValue()) != null && !this.mayBeRegExp(firstValue)) {
                    String unEscapedLiteral = this.unEscapeCharacters(firstValue);
                    invocation = invocation.withName(invocation.getName().withSimpleName("replace")).withArguments(ListUtils.mapFirst((List)invocation.getArguments(), arg -> ((J.Literal)arg).withValue((Object)unEscapedLiteral).withValueSource(String.format("\"%s\"", StringEscapeUtils.escapeJava((String)unEscapedLiteral)))));
                }
            }
            return invocation;
        }

        private boolean isStringLiteral(Expression expression) {
            return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
        }

        private boolean mayBeRegExp(String argument) {
            String cleanedValue = ESCAPED_CHARACTER.matcher(argument).replaceAll("");
            return METACHARACTERS.matcher(cleanedValue).find() || CHARACTER_CLASSES.matcher(cleanedValue).find();
        }

        private String unEscapeCharacters(String argument) {
            return argument.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\'", "'").replace("\\", "");
        }
    }
}

