/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UseStandardCharset
extends Recipe {
    final String displayName = "Use `StandardCharset` constants";
    final String description = "Replaces `Charset.forName(java.lang.String)` with the equivalent `StandardCharset` constant.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.nio.charset.Charset", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final MethodMatcher CHARSET_FOR_NAME = new MethodMatcher("java.nio.charset.Charset forName(java.lang.String)");

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.CHARSET_FOR_NAME.matches((MethodCall)m)) {
                    Expression charsetName = (Expression)m.getArguments().get(0);
                    if (!(charsetName instanceof J.Literal)) {
                        return m;
                    }
                    String maybeReplace = (String)((J.Literal)charsetName).getValue();
                    if (maybeReplace != null) {
                        Charset charset;
                        this.maybeAddImport("java.nio.charset.StandardCharsets");
                        try {
                            charset = Charset.forName(maybeReplace);
                        }
                        catch (UnsupportedCharsetException ex) {
                            return method;
                        }
                        String standardName = "";
                        if (charset == StandardCharsets.ISO_8859_1) {
                            standardName = "ISO_8859_1";
                        } else if (charset == StandardCharsets.US_ASCII) {
                            standardName = "US_ASCII";
                        } else if (charset == StandardCharsets.UTF_8) {
                            standardName = "UTF_8";
                        } else if (charset == StandardCharsets.UTF_16) {
                            standardName = "UTF_16";
                        } else if (charset == StandardCharsets.UTF_16BE) {
                            standardName = "UTF_16BE";
                        } else if (charset == StandardCharsets.UTF_16LE) {
                            standardName = "UTF_16LE";
                        }
                        if (!StringUtils.isBlank((String)standardName)) {
                            return JavaTemplate.builder((String)("StandardCharsets." + standardName)).imports(new String[]{"java.nio.charset.StandardCharsets"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[0]);
                        }
                    }
                }
                return m;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

