/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class UnnecessaryReturnAsLastStatement
extends Recipe {
    final String displayName = "Unnecessary `return` as last statement in void method";
    final String description = "Removes `return` from a `void` method if it's the last statement.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (TypeUtils.asPrimitive((JavaType)m.getType()) == JavaType.Primitive.Void && m.getBody() != null) {
                    return m.withBody(m.getBody().withStatements(ListUtils.mapLast((List)m.getBody().getStatements(), this::maybeRemoveReturn)));
                }
                return m;
            }

            private @Nullable Statement maybeRemoveReturn(Statement s) {
                if (s instanceof J.Return && ((J.Return)s).getExpression() == null) {
                    return null;
                }
                if (s instanceof J.Block) {
                    J.Block block = (J.Block)s;
                    return block.withStatements(ListUtils.mapLast((List)block.getStatements(), this::maybeRemoveReturn));
                }
                if (s instanceof J.If) {
                    J.If ifStatement = (J.If)s;
                    Statement trimmedThen = this.maybeRemoveReturn(ifStatement.getThenPart());
                    if (trimmedThen != ifStatement.getThenPart() && trimmedThen != null) {
                        ifStatement = ifStatement.withThenPart(trimmedThen);
                    }
                    if (ifStatement.getElsePart() != null) {
                        Statement trimmedElse = this.maybeRemoveReturn(ifStatement.getElsePart().getBody());
                        if (trimmedElse == null) {
                            return ifStatement.withElsePart(null);
                        }
                        if (trimmedElse != ifStatement.getElsePart().getBody()) {
                            return ifStatement.withElsePart(ifStatement.getElsePart().withBody(trimmedElse));
                        }
                    }
                    return ifStatement;
                }
                return s;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

