/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TypecastParenPadStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.style.Style;

public class TypecastParenPad
extends Recipe {
    final String displayName = "Typecast parenthesis padding";
    final String description = "Fixes whitespace padding between a typecast type identifier and the enclosing left and right parentheses. For example, when configured to remove spacing, `( int ) 0L;` becomes `(int) 0L;`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new GroovyFileChecker()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            SpacesStyle spacesStyle;
            TypecastParenPadStyle typecastParenPadStyle;

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    SourceFile cu = (SourceFile)tree;
                    this.spacesStyle = (SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces);
                    this.typecastParenPadStyle = (TypecastParenPadStyle)Style.from(TypecastParenPadStyle.class, (SourceFile)cu, Checkstyle::typecastParenPadStyle);
                    this.spacesStyle = this.spacesStyle.withWithin(this.spacesStyle.getWithin().withTypeCastParentheses(this.typecastParenPadStyle.getSpace()));
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.TypeCast visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                J.TypeCast tc = super.visitTypeCast(typeCast, (Object)ctx);
                return (J.TypeCast)new SpacesVisitor(this.spacesStyle, null, null, (Tree)tc).visitNonNull((Tree)tc, (Object)ctx, this.getCursor().getParentTreeCursor().fork());
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

