/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class SortedSetStreamToLinkedHashSet
extends Recipe {
    private final String displayName = "Sorted set stream should be collected to LinkedHashSet";
    private final String description = "Converts `set.stream().sorted().collect(Collectors.toSet())` to `set.stream().sorted().collect(LinkedHashSet::new)`.";
    private static final MethodMatcher STREAM_COLLECT_METHOD_MATCHER = new MethodMatcher("java.util.stream.Stream collect(java.util.stream.Collector)");
    private static final MethodMatcher STREAM_SORTED_METHOD_MATCHER = new MethodMatcher("java.util.stream.Stream sorted()");
    private static final MethodMatcher COLLECTORS_TO_SET_METHOD_MATCHER = new MethodMatcher("java.util.stream.Collectors toSet()");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(COLLECTORS_TO_SET_METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final JavaTemplate template = JavaTemplate.builder((String)"Collectors.toCollection(LinkedHashSet::new)").imports(new String[]{"java.util.stream.Collectors", "java.util.LinkedHashSet"}).build();

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (STREAM_COLLECT_METHOD_MATCHER.matches((MethodCall)mi) && STREAM_SORTED_METHOD_MATCHER.matches(mi.getSelect()) && COLLECTORS_TO_SET_METHOD_MATCHER.matches((Expression)mi.getArguments().get(0))) {
                    this.maybeRemoveImport("java.util.stream.Collectors.toSet");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    this.maybeAddImport("java.util.stream.Collectors");
                    return (J.MethodInvocation)this.template.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replaceArguments(), new Object[0]);
                }
                return mi;
            }
        });
    }

    @Generated
    public SortedSetStreamToLinkedHashSet() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "SortedSetStreamToLinkedHashSet(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortedSetStreamToLinkedHashSet)) {
            return false;
        }
        SortedSetStreamToLinkedHashSet other = (SortedSetStreamToLinkedHashSet)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortedSetStreamToLinkedHashSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

