/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ParenthesizeVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class SimplifyBooleanExpressionWithDeMorgan
extends Recipe {
    final String displayName = "Simplify boolean expressions using De Morgan's laws";
    final String description = "Applies De Morgan's laws to simplify boolean expressions with negation. Transforms `!(a && b)` to `!a || !b` and `!(a || b)` to `!a && !b`.";
    final Set<String> tags = Collections.singleton("RSPEC-1125");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J.Parentheses parentheses;
                if (unary.getOperator() == J.Unary.Type.Not && unary.getExpression() instanceof J.Parentheses && (parentheses = (J.Parentheses)unary.getExpression()).getTree() instanceof J.Binary) {
                    J.Binary binary = (J.Binary)parentheses.getTree();
                    J.Parentheses parenthesesBinary = (J.Parentheses)unary.getExpression();
                    J.Binary.Type newOperator = null;
                    if (binary.getOperator() == J.Binary.Type.And) {
                        newOperator = J.Binary.Type.Or;
                    } else if (binary.getOperator() == J.Binary.Type.Or) {
                        newOperator = J.Binary.Type.And;
                    }
                    Expression left = binary.getLeft();
                    Expression right = binary.getRight();
                    if (newOperator != null) {
                        left = this.negate(left);
                        left = (Expression)new ParenthesizeVisitor().visit((Tree)left, (Object)ctx);
                        right = this.negate(right);
                        right = (Expression)new ParenthesizeVisitor().visit((Tree)right, (Object)ctx);
                    }
                    left = (Expression)this.visit((Tree)left, ctx);
                    right = (Expression)this.visit((Tree)right, ctx);
                    if (newOperator == null) {
                        J.Binary visitedBinary = binary.withLeft(left).withRight(right);
                        return unary.withExpression((Expression)parenthesesBinary.withTree((J)visitedBinary));
                    }
                    Space prefix = unary.getPrefix();
                    ArrayList comments = new ArrayList(prefix.getComments());
                    comments.addAll(parenthesesBinary.getComments());
                    comments.addAll(binary.getComments());
                    prefix = prefix.withComments(comments);
                    this.getCursor().getParent().putMessage("MIGHT_NEED_PARENTHESES", (Object)true);
                    return binary.withLeft(left).withRight(right).withOperator(newOperator).withPrefix(prefix);
                }
                return Objects.requireNonNull(super.visitUnary(unary, (Object)ctx));
            }

            public @Nullable J postVisit(@NonNull J tree, ExecutionContext ctx) {
                J ret = (J)super.postVisit((Tree)tree, (Object)ctx);
                if (this.getCursor().pollMessage("MIGHT_NEED_PARENTHESES") != null) {
                    return (J)new ParenthesizeVisitor().visit((Tree)ret, (Object)ctx);
                }
                return ret;
            }

            private Expression negate(Expression expression) {
                J.Unary unaryExpr;
                if (expression instanceof J.Unary && (unaryExpr = (J.Unary)expression).getOperator() == J.Unary.Type.Not) {
                    return (Expression)unaryExpr.getExpression().withPrefix(expression.getPrefix());
                }
                return new J.Unary(Tree.randomId(), expression.getPrefix(), Markers.EMPTY, new JLeftPadded(Space.EMPTY, (Object)J.Unary.Type.Not, Markers.EMPTY), (Expression)expression.withPrefix(Space.EMPTY), (JavaType)JavaType.Primitive.Boolean);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

