/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;

public class RenameExceptionInEmptyCatch
extends Recipe {
    final String displayName = "Rename caught exceptions in empty catch blocks to `ignored`";
    final String description = "Renames caught exceptions in empty catch blocks to `ignored`. `ignored` will be incremented by 1 if a namespace conflict exists.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    LinkedHashMap variableScopes = new LinkedHashMap();
                    this.getCursor().putMessage("VARIABLES_KEY", variableScopes);
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                Map variableScope = (Map)this.getCursor().getNearestMessage("VARIABLES_KEY");
                if (variableScope != null) {
                    for (Statement o : classDecl.getBody().getStatements()) {
                        if (!(o instanceof J.VariableDeclarations)) continue;
                        J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)o;
                        for (J.VariableDeclarations.NamedVariable v : variableDeclarations.getVariables()) {
                            variableScope.computeIfAbsent(this.getCursor(), k -> new HashSet()).add(v.getSimpleName());
                        }
                    }
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                Map variableScope;
                Cursor parentScope;
                if (this.validIdentifier() && !((parentScope = this.getCursorToParentScope()).getValue() instanceof J.ClassDeclaration) && (variableScope = (Map)this.getCursor().getNearestMessage("VARIABLES_KEY")) != null) {
                    Set namesInScope = variableScope.computeIfAbsent(parentScope, k -> new HashSet());
                    namesInScope.add(identifier.getSimpleName());
                }
                return super.visitIdentifier(identifier, (Object)ctx);
            }

            public J.Try.Catch visitCatch(J.Try.Catch aCatch, ExecutionContext ctx) {
                if (aCatch.getBody().getStatements().isEmpty() && aCatch.getBody().getEnd().getComments().isEmpty()) {
                    return super.visitCatch(aCatch, (Object)ctx);
                }
                return aCatch;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                Map variableScopes;
                Cursor parentScope = this.getCursorToParentScope();
                if (parentScope.getValue() instanceof J.Try.Catch && (variableScopes = (Map)this.getCursor().getNearestMessage("VARIABLES_KEY")) != null) {
                    Set namesInScope = variableScopes.computeIfAbsent(parentScope, k -> new HashSet());
                    namesInScope.addAll(multiVariable.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).collect(Collectors.toList()));
                    this.aggregateNameScopes(variableScopes);
                    String baseName = "ignored";
                    int count = 0;
                    for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                        if (variable.getSimpleName().contains(baseName)) continue;
                        String newName = baseName;
                        while (variableScopes.containsKey(parentScope) && ((Set)variableScopes.get(parentScope)).contains(newName)) {
                            newName = baseName + ++count;
                        }
                        this.doAfterVisit((TreeVisitor)new RenameVariable(variable, newName));
                        namesInScope.add(newName);
                    }
                }
                return super.visitVariableDeclarations(multiVariable, (Object)ctx);
            }

            private void aggregateNameScopes(Map<Cursor, Set<String>> variableScopes) {
                ArrayList<Cursor> parentScopes = new ArrayList<Cursor>(variableScopes.keySet());
                for (Cursor parentScope : parentScopes) {
                    for (Cursor maybeInScope : parentScopes) {
                        if (!parentScope.isScopeInPath((Tree)maybeInScope.getValue())) continue;
                        variableScopes.get(parentScope).addAll((Collection<String>)variableScopes.get(maybeInScope));
                    }
                }
            }

            private boolean validIdentifier() {
                Cursor parent = this.getCursor().getParent();
                return parent != null && !(parent.getValue() instanceof J.ClassDeclaration) && !(parent.getValue() instanceof J.MethodDeclaration) && !(parent.getValue() instanceof J.MethodInvocation);
            }

            private Cursor getCursorToParentScope() {
                return this.getCursor().dropParentUntil(is -> is instanceof J.CompilationUnit || is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

