/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class RemoveHashCodeCallsFromArrayInstances
extends Recipe {
    private static final MethodMatcher HASHCODE_MATCHER = new MethodMatcher("java.lang.Object hashCode()");
    final String displayName = "`hashCode()` should not be called on array instances";
    final String description = "Replace `hashCode()` calls on arrays with `Arrays.hashCode()` because the results from `hashCode()` are not helpful.";
    final Set<String> tags = Collections.singleton("RSPEC-S2116");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(HASHCODE_MATCHER), (TreeVisitor)new RemoveHashCodeCallsFromArrayInstancesVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    private static class RemoveHashCodeCallsFromArrayInstancesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveHashCodeCallsFromArrayInstancesVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            Expression select;
            J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
            if (HASHCODE_MATCHER.matches((MethodCall)mi) && (select = mi.getSelect()) != null && select.getType() instanceof JavaType.Array) {
                this.maybeAddImport("java.util.Arrays");
                return (J.MethodInvocation)JavaTemplate.builder((String)"Arrays.hashCode(#{anyArray(java.lang.Object)})").imports(new String[]{"java.util.Arrays"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{select});
            }
            return mi;
        }
    }
}

