/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class RemoveExtraSemicolons
extends Recipe {
    final String displayName = "Remove extra semicolons";
    final String description = "Removes not needed semicolons. Semicolons are considered not needed:\n * Optional semicolons at the end of try-with-resources,\n * after the last enum value if no field or method is defined,\n * no statement between two semicolon.";
    final Set<String> tags = new LinkedHashSet<String>(Arrays.asList("RSPEC-S1116", "RSPEC-S2959"));
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Space visitSpace(@Nullable Space space, Space.Location loc, ExecutionContext ctx) {
                if (space.getWhitespace().contains(";")) {
                    return space.withWhitespace(space.getWhitespace().replace(";", ""));
                }
                return space;
            }

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                Iterator iterator = block.getStatements().iterator();
                ArrayList<Statement> result = new ArrayList<Statement>();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    if (statement instanceof J.Empty) {
                        RemoveExtraSemicolons.this.nextNonEmptyAggregatedWithComments(statement, iterator).ifPresent(nextLine -> {
                            String whitespace = statement.getPrefix().getWhitespace();
                            if (!whitespace.contains("\n") && nextLine.getComments().isEmpty()) {
                                result.add((Statement)nextLine);
                            } else {
                                Space updatedPrefix = nextLine.getPrefix().withWhitespace(whitespace);
                                result.add((Statement)nextLine.withPrefix(updatedPrefix));
                            }
                        });
                        continue;
                    }
                    result.add(statement);
                }
                return super.visitBlock(block.withStatements(result), (Object)ctx);
            }

            public J.Try.Resource visitTryResource(J.Try.Resource tr, ExecutionContext ctx) {
                J.Try _try = (J.Try)this.getCursor().dropParentUntil(J.Try.class::isInstance).getValue();
                if (_try.getResources().isEmpty() || _try.getResources().get(_try.getResources().size() - 1) != tr || !((J.Try.Resource)_try.getResources().get(_try.getResources().size() - 1)).isTerminatedWithSemicolon()) {
                    return tr;
                }
                return tr.withTerminatedWithSemicolon(false);
            }

            public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enums, ExecutionContext ctx) {
                J.EnumValueSet e = super.visitEnumValueSet(enums, (Object)ctx);
                if (((J.Block)this.getCursor().firstEnclosing(J.Block.class)).getStatements().size() == 1) {
                    e = e.withTerminatedWithSemicolon(false);
                }
                return e;
            }
        };
    }

    private Optional<Statement> nextNonEmptyAggregatedWithComments(Statement current, Iterator<Statement> iterator) {
        ArrayList comments = new ArrayList(current.getComments());
        while (iterator.hasNext()) {
            Statement statement = iterator.next();
            comments.addAll(statement.getComments());
            if (statement instanceof J.Empty) continue;
            return Optional.of((Statement)statement.withComments(comments));
        }
        return Optional.empty();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

