/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.tree.K;

public final class MissingOverrideAnnotation
extends Recipe {
    @Option(displayName="Ignore methods in anonymous classes", description="When enabled, ignore missing annotations on methods which override methods when the class definition is within an anonymous class.", required=false)
    private final @Nullable Boolean ignoreAnonymousClassMethods;
    private final String displayName = "Add missing `@Override` to overriding and implementing methods";
    private final String description = "Adds `@Override` to methods overriding superclass methods or implementing interface methods. Annotating methods improves readability by showing the author's intent to override. Additionally, when annotated, the compiler will emit an error when a signature of the overridden method does not match the superclass method.";
    private final Set<String> tags = Collections.singleton("RSPEC-S1161");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    @Generated
    public MissingOverrideAnnotation(@Nullable Boolean ignoreAnonymousClassMethods) {
        this.ignoreAnonymousClassMethods = ignoreAnonymousClassMethods;
    }

    @Generated
    public @Nullable Boolean getIgnoreAnonymousClassMethods() {
        return this.ignoreAnonymousClassMethods;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String toString() {
        return "MissingOverrideAnnotation(ignoreAnonymousClassMethods=" + this.getIgnoreAnonymousClassMethods() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MissingOverrideAnnotation)) {
            return false;
        }
        MissingOverrideAnnotation other = (MissingOverrideAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        Boolean other$ignoreAnonymousClassMethods = other.getIgnoreAnonymousClassMethods();
        if (this$ignoreAnonymousClassMethods == null ? other$ignoreAnonymousClassMethods != null : !((Object)this$ignoreAnonymousClassMethods).equals(other$ignoreAnonymousClassMethods)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MissingOverrideAnnotation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        result = result * 59 + ($ignoreAnonymousClassMethods == null ? 43 : ((Object)$ignoreAnonymousClassMethods).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private class MissingOverrideAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");

        private MissingOverrideAnnotationVisitor() {
        }

        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return super.isAcceptable(sourceFile, (Object)ctx) && !(sourceFile instanceof K.CompilationUnit);
        }

        private Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.ClassDeclaration);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!(method.hasModifier(J.Modifier.Type.Static) || method.isConstructor() || ((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), this.OVERRIDE_ANNOTATION) || !TypeUtils.isOverride((JavaType.Method)method.getMethodType()) || Boolean.TRUE.equals(MissingOverrideAnnotation.this.ignoreAnonymousClassMethods) && this.getCursorToParentScope(this.getCursor()).getValue() instanceof J.NewClass)) {
                method = (J.MethodDeclaration)JavaTemplate.apply((String)"@Override", (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), (Object[])new Object[0]);
            }
            return super.visitMethodDeclaration(method, (Object)ctx);
        }
    }
}

