/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.ExplicitInitializationStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.style.Style;

public class ExplicitInitializationVisitor<P>
extends JavaIsoVisitor<P> {
    private static final AnnotationMatcher LOMBOK_VALUE = new AnnotationMatcher("@lombok.Value");
    private static final AnnotationMatcher LOMBOK_BUILDER_DEFAULT = new AnnotationMatcher("@lombok.Builder.Default");
    private ExplicitInitializationStyle style;

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.style == null && tree instanceof SourceFile) {
            this.style = (ExplicitInitializationStyle)Style.from(ExplicitInitializationStyle.class, (SourceFile)((SourceFile)tree), Checkstyle::explicitInitialization);
        }
        return (J)super.visit(tree, p);
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, p);
        Cursor variableDeclsCursor = this.getCursor().getParentTreeCursor();
        Cursor maybeBlockOrGType = variableDeclsCursor.getParentTreeCursor();
        if (maybeBlockOrGType.getParent() == null || maybeBlockOrGType.getParent().getParent() == null) {
            return v;
        }
        J maybeClassDecl = (J)maybeBlockOrGType.getParentTreeCursor().getValue();
        if (!(maybeClassDecl instanceof J.ClassDeclaration) && !(maybeClassDecl instanceof J.NewClass)) {
            return v;
        }
        if (!(maybeClassDecl instanceof J.NewClass) && J.ClassDeclaration.Kind.Type.Class != ((J.ClassDeclaration)maybeClassDecl).getKind()) {
            return v;
        }
        if (!(variableDeclsCursor.getValue() instanceof J.VariableDeclarations)) {
            return v;
        }
        Iterator clz = this.getCursor().getPathAsCursors(c -> c.getValue() instanceof J.ClassDeclaration);
        if (clz.hasNext() && ((AnnotationService)this.service(AnnotationService.class)).matches((Cursor)clz.next(), LOMBOK_VALUE)) {
            return v;
        }
        JavaType.Primitive primitive = TypeUtils.asPrimitive((JavaType)variable.getType());
        JavaType.Array array = TypeUtils.asArray((JavaType)variable.getType());
        J.VariableDeclarations variableDecls = (J.VariableDeclarations)variableDeclsCursor.getValue();
        if (((AnnotationService)this.service(AnnotationService.class)).matches(variableDeclsCursor, LOMBOK_BUILDER_DEFAULT)) {
            return v;
        }
        if (variable.getInitializer() instanceof J.Literal && !variableDecls.hasModifier(J.Modifier.Type.Final)) {
            J.Literal literalInit = (J.Literal)variable.getInitializer();
            if (TypeUtils.asFullyQualified((JavaType)variable.getType()) != null && JavaType.Primitive.Null == literalInit.getType()) {
                v = v.withInitializer(null);
            } else if (primitive != null && !Boolean.TRUE.equals(this.style.getOnlyObjectReferences())) {
                switch (primitive) {
                    case Boolean: {
                        if (literalInit.getValue() != Boolean.valueOf(false)) break;
                        v = v.withInitializer(null);
                        break;
                    }
                    case Char: {
                        if (!(literalInit.getValue() instanceof Character) || ((Character)literalInit.getValue()).charValue() != '\u0000') break;
                        v = v.withInitializer(null);
                        break;
                    }
                    case Int: 
                    case Long: 
                    case Short: {
                        if (!(literalInit.getValue() instanceof Number) || ((Number)literalInit.getValue()).intValue() != 0) break;
                        v = v.withInitializer(null);
                    }
                }
            } else if (array != null && JavaType.Primitive.Null == literalInit.getType()) {
                v = v.withInitializer(null).withDimensionsAfterName(ListUtils.map((List)v.getDimensionsAfterName(), (i, dim) -> i == 0 ? dim.withBefore(Space.EMPTY) : dim));
            }
        }
        return v;
    }

    @Generated
    public ExplicitInitializationVisitor() {
    }

    @Generated
    public ExplicitInitializationVisitor(ExplicitInitializationStyle style) {
        this.style = style;
    }
}

