/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class EqualsAvoidsNull
extends Recipe {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcher EQUALS_STRING = new MethodMatcher("java.lang.String equals(java.lang.Object)");
    private static final MethodMatcher EQUALS_OBJECT = new MethodMatcher("java.lang.Object equals(java.lang.Object)");
    private static final MethodMatcher EQUALS_IGNORE_CASE = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
    private static final MethodMatcher CONTENT_EQUALS = new MethodMatcher("java.lang.String contentEquals(java.lang.CharSequence)");
    private final String displayName = "Equals avoids null";
    private final String description = "Checks that any combination of String literals is on the left side of an `equals()` comparison. Also checks for String literals assigned to some field (such as `someString.equals(anotherString = \"text\"))`. And removes redundant null checks in conjunction with equals comparisons.";
    private final Set<String> tags = Collections.singleton("RSPEC-S1132");
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(10L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(EQUALS_STRING), new UsesMethod(EQUALS_OBJECT), new UsesMethod(EQUALS_IGNORE_CASE), new UsesMethod(CONTENT_EQUALS)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (mi.getSelect() instanceof J.Literal || !this.isStringComparisonMethod((J)mi) || !this.hasCompatibleArgument(mi)) {
                    return mi;
                }
                Expression firstArgument = (Expression)mi.getArguments().get(0);
                return firstArgument.getType() == JavaType.Primitive.Null ? this.literalsFirstInComparisonsNull(mi, firstArgument) : this.literalsFirstInComparisons(mi, firstArgument);
            }

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                Expression nullCheckedLeft;
                J.Binary b = (J.Binary)super.visitBinary(binary, (Object)ctx);
                if (b.getLeft() instanceof J.Binary && b.getOperator() == J.Binary.Type.And && this.isStringComparisonMethod((J)b.getRight()) && (nullCheckedLeft = this.nullCheckedArgument((J.Binary)b.getLeft())) != null && SemanticallyEqual.areEqual((J)nullCheckedLeft, (J)((J)((J.MethodInvocation)b.getRight()).getArguments().get(0)))) {
                    return b.getRight().withPrefix(b.getPrefix());
                }
                return b;
            }

            private @Nullable Expression nullCheckedArgument(J.Binary binary) {
                if (binary.getOperator() == J.Binary.Type.NotEqual) {
                    if (J.Literal.isLiteralValue((Expression)binary.getLeft(), null)) {
                        return binary.getRight();
                    }
                    if (J.Literal.isLiteralValue((Expression)binary.getRight(), null)) {
                        return binary.getLeft();
                    }
                }
                return null;
            }

            private boolean hasCompatibleArgument(J.MethodInvocation m) {
                if (m.getArguments().isEmpty()) {
                    return false;
                }
                Expression firstArgument = (Expression)m.getArguments().get(0);
                if (firstArgument instanceof J.Literal) {
                    return true;
                }
                if (firstArgument instanceof J.FieldAccess) {
                    firstArgument = ((J.FieldAccess)firstArgument).getName();
                }
                if (firstArgument instanceof J.Identifier) {
                    JavaType.Variable fieldType = ((J.Identifier)firstArgument).getFieldType();
                    return fieldType != null && fieldType.hasFlags(new Flag[]{Flag.Static, Flag.Final});
                }
                return false;
            }

            private boolean isStringComparisonMethod(J j) {
                if (j instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)j;
                    return EQUALS_STRING.matches((MethodCall)mi) || EQUALS_OBJECT.matches((MethodCall)mi) && TypeUtils.isString((JavaType)((Expression)mi.getArguments().get(0)).getType()) || EQUALS_IGNORE_CASE.matches((MethodCall)mi) || CONTENT_EQUALS.matches((MethodCall)mi);
                }
                return false;
            }

            private J.Binary literalsFirstInComparisonsNull(J.MethodInvocation m, Expression firstArgument) {
                return new J.Binary(Tree.randomId(), m.getPrefix(), Markers.EMPTY, Objects.requireNonNull(m.getSelect()), JLeftPadded.build((Object)J.Binary.Type.Equal).withBefore(Space.SINGLE_SPACE), (Expression)firstArgument.withPrefix(Space.SINGLE_SPACE), (JavaType)JavaType.Primitive.Boolean);
            }

            private J.MethodInvocation literalsFirstInComparisons(J.MethodInvocation m, Expression firstArgument) {
                if (!(firstArgument instanceof J.Literal) && !(m.getSelect() instanceof J.Literal) && firstArgument.toString().compareTo(m.getSelect().toString()) > 0) {
                    return m;
                }
                return m.withSelect((Expression)firstArgument.withPrefix(Objects.requireNonNull(m.getSelect()).getPrefix())).withArguments(Collections.singletonList((Expression)m.getSelect().withPrefix(Space.EMPTY)));
            }
        });
    }

    @Generated
    public EqualsAvoidsNull() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public String toString() {
        return "EqualsAvoidsNull(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsAvoidsNull)) {
            return false;
        }
        EqualsAvoidsNull other = (EqualsAvoidsNull)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EqualsAvoidsNull;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

