/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.ModifierOrder;

public class FinalClassVisitor
extends JavaIsoVisitor<ExecutionContext> {
    Tree visitRoot;
    final Set<String> typesToFinalize = new HashSet<String>();
    final Set<String> typesToNotFinalize = new HashSet<String>();

    public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
        boolean root = false;
        if (this.visitRoot == null && tree != null) {
            this.visitRoot = tree;
            root = true;
        }
        J result = (J)super.visit(tree, (Object)ctx);
        if (root) {
            this.visitRoot = null;
            this.typesToFinalize.removeAll(this.typesToNotFinalize);
            if (!this.typesToFinalize.isEmpty()) {
                result = (J)new FinalizingVisitor(this.typesToFinalize).visit(tree, ctx);
            }
        }
        return result;
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
        if (cd.getKind() != J.ClassDeclaration.Kind.Type.Class || cd.getType() == null) {
            return cd;
        }
        this.excludeSupertypes(cd.getType());
        if (cd.hasModifier(J.Modifier.Type.Abstract) || cd.hasModifier(J.Modifier.Type.Final)) {
            return cd;
        }
        boolean allPrivate = true;
        int constructorCount = 0;
        for (Statement s : cd.getBody().getStatements()) {
            if (s instanceof J.MethodDeclaration && ((J.MethodDeclaration)s).isConstructor()) {
                J.MethodDeclaration constructor = (J.MethodDeclaration)s;
                ++constructorCount;
                if (!constructor.hasModifier(J.Modifier.Type.Private)) {
                    allPrivate = false;
                }
            }
            if (constructorCount <= 0 || allPrivate) continue;
            return cd;
        }
        if (constructorCount > 0) {
            this.typesToFinalize.add(cd.getType().getFullyQualifiedName());
        }
        return cd;
    }

    private void excludeSupertypes(JavaType.FullyQualified type) {
        if (type.getSupertype() != null && this.typesToNotFinalize.add(type.getSupertype().getFullyQualifiedName())) {
            this.excludeSupertypes(type.getSupertype());
        }
    }

    private static class FinalizingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Set<String> typesToFinalize;

        public FinalizingVisitor(Set<String> typesToFinalize) {
            this.typesToFinalize = typesToFinalize;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getType() != null && this.typesToFinalize.remove(cd.getType().getFullyQualifiedName())) {
                List<J.Modifier> modifiers = new ArrayList<J.Modifier>(cd.getModifiers());
                modifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList()));
                modifiers = ModifierOrder.sortModifiers(modifiers);
                cd = cd.withModifiers(modifiers);
                if (cd.getType() instanceof JavaType.Class && !cd.getType().hasFlags(new Flag[]{Flag.Final})) {
                    HashSet<Flag> flags = new HashSet<Flag>(cd.getType().getFlags());
                    flags.add(Flag.Final);
                    cd = cd.withType(((JavaType.Class)cd.getType()).withFlags(flags));
                }
                if (!cd.getLeadingAnnotations().isEmpty()) {
                    cd = cd.getPadding().withKind(cd.getPadding().getKind().withPrefix(Space.EMPTY));
                }
                assert (this.getCursor().getParent() != null);
                cd = (J.ClassDeclaration)this.autoFormat((J)cd, (J)cd.getName(), ctx, this.getCursor().getParent());
            }
            return cd;
        }
    }
}

