/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Statement;

public class MoveConditionsToWhile
extends Recipe {
    public String getDisplayName() {
        return "Convert `while (true)` with initial `if` break to loop condition";
    }

    public String getDescription() {
        return "Simplifies `while (true)` loops where the first statement is an `if` statement that only contains a `break`. The condition is inverted and moved to the loop condition for better readability.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext ctx) {
                J.Break breakStatement;
                J.WhileLoop wl = (J.WhileLoop)super.visitWhileLoop(whileLoop, (Object)ctx);
                if (!(wl.getCondition().getTree() instanceof J.Literal && J.Literal.isLiteralValue((Expression)((Expression)wl.getCondition().getTree()), (Object)true) && wl.getBody() instanceof J.Block)) {
                    return wl;
                }
                List statements = ((J.Block)wl.getBody()).getStatements();
                if (statements.isEmpty() || !(statements.get(0) instanceof J.If)) {
                    return wl;
                }
                J.If ifStatement = (J.If)statements.get(0);
                if (ifStatement.getElsePart() != null) {
                    return wl;
                }
                Statement thenBody = ifStatement.getThenPart();
                if (thenBody instanceof J.Block) {
                    J.Block thenBlock = (J.Block)thenBody;
                    if (thenBlock.getStatements().size() != 1 || !(thenBlock.getStatements().get(0) instanceof J.Break)) {
                        return wl;
                    }
                    breakStatement = (J.Break)thenBlock.getStatements().get(0);
                } else if (thenBody instanceof J.Break) {
                    breakStatement = (J.Break)thenBody;
                } else {
                    return wl;
                }
                if (breakStatement.getLabel() != null) {
                    return wl;
                }
                this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                return JavaTemplate.apply((String)"while (!(#{any()})) #{}", (Cursor)this.getCursor(), (JavaCoordinates)wl.getCoordinates().replace(), (Object[])new Object[]{ifStatement.getIfCondition().getTree(), ((J.Block)wl.getBody()).withStatements(statements.subList(1, statements.size()))});
            }
        };
    }
}

