/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class UnwrapElseAfterReturn
extends Recipe {
    public String getDisplayName() {
        return "Unwrap else block after return or throw statement";
    }

    public String getDescription() {
        return "Unwraps the else block when the if block ends with a return or throw statement, reducing nesting and improving code readability.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = (J.Block)this.visitAndCast((Tree)block, ctx, (x$0, x$1) -> super.visitBlock(x$0, x$1));
                J.Block after = b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.If ifStatement;
                    if (statement instanceof J.If && (ifStatement = (J.If)statement).getElsePart() != null && this.endsWithReturnOrThrow(ifStatement.getThenPart())) {
                        J.If newIf = ifStatement.withElsePart(null);
                        Statement elsePart = ifStatement.getElsePart().getBody();
                        if (elsePart instanceof J.Block) {
                            J.Block elseBlock = (J.Block)elsePart;
                            return ListUtils.concat((Object)newIf, (List)ListUtils.mapFirst((List)elseBlock.getStatements(), elseStmt -> {
                                List elseComments = elseBlock.getPrefix().getComments();
                                List stmtComments = elseStmt.getPrefix().getComments();
                                if (!elseComments.isEmpty() || !stmtComments.isEmpty()) {
                                    return (Statement)elseStmt.withComments(ListUtils.concatAll((List)elseComments, (List)stmtComments));
                                }
                                String whitespace = ifStatement.getElsePart().getPrefix().getWhitespace();
                                return (Statement)elseStmt.withPrefix(elseStmt.getPrefix().withWhitespace(whitespace));
                            }));
                        }
                        return Arrays.asList(newIf, (Statement)elsePart.withPrefix(ifStatement.getElsePart().getPrefix()));
                    }
                    return statement;
                }));
                return (J.Block)this.maybeAutoFormat((J)b, (J)after, ctx);
            }

            private boolean endsWithReturnOrThrow(Statement statement) {
                J.Block block;
                if (statement instanceof J.Return || statement instanceof J.Throw) {
                    return true;
                }
                if (statement instanceof J.Block && !(block = (J.Block)statement).getStatements().isEmpty()) {
                    Statement lastStatement = (Statement)block.getStatements().get(block.getStatements().size() - 1);
                    return lastStatement instanceof J.Return || lastStatement instanceof J.Throw;
                }
                return false;
            }
        };
        return Repeat.repeatUntilStable((TreeVisitor)javaVisitor);
    }
}

