/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RenameMethodsNamedHashcodeEqualOrTostring
extends Recipe {
    private static final MethodMatcher NO_ARGS = new MethodMatcher("*..* *()", true);
    private static final MethodMatcher OBJECT_ARG = new MethodMatcher("*..* *(java.lang.Object)", true);

    public String getDisplayName() {
        return "Rename methods named `hashcode`, `equal`, or `tostring`";
    }

    public String getDescription() {
        return "Methods should not be named `hashcode`, `equal`, or `tostring`. Any of these are confusing as they appear to be intended as overridden methods from the `Object` base class, despite being case-insensitive.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1221");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new DeclaresMethod(NO_ARGS), new DeclaresMethod(OBJECT_ARG)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (method.getMethodType() != null && method.getReturnTypeExpression() != null) {
                    String sn = method.getSimpleName();
                    JavaType rte = method.getReturnTypeExpression().getType();
                    JavaType.Method t = method.getMethodType();
                    if (this.equalsIgnoreCaseExclusive(sn, "hashCode") && JavaType.Primitive.Int.equals((Object)rte) && NO_ARGS.matches(t)) {
                        this.doAfterVisit(new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)method), "hashCode", Boolean.valueOf(true), Boolean.valueOf(false)).getVisitor());
                    } else if ("equal".equalsIgnoreCase(sn) && JavaType.Primitive.Boolean.equals((Object)rte) && OBJECT_ARG.matches(t)) {
                        this.doAfterVisit(new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)method), "equals", Boolean.valueOf(true), Boolean.valueOf(false)).getVisitor());
                    } else if (this.equalsIgnoreCaseExclusive(sn, "toString") && TypeUtils.isString((JavaType)rte) && NO_ARGS.matches(t)) {
                        this.doAfterVisit(new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)method), "toString", Boolean.valueOf(true), Boolean.valueOf(false)).getVisitor());
                    }
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private boolean equalsIgnoreCaseExclusive(String inputToCheck, String targetToCheck) {
                return inputToCheck.equalsIgnoreCase(targetToCheck) && !inputToCheck.equals(targetToCheck);
            }
        });
    }
}

