/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

@Incubating(since="7.10.0")
public class IndexOfReplaceableByContains
extends Recipe {
    private static final MethodMatcher STRING_INDEX_MATCHER = new MethodMatcher("java.lang.String indexOf(String)");
    private static final MethodMatcher LIST_INDEX_MATCHER = new MethodMatcher("java.util.List indexOf(Object)");

    public String getDisplayName() {
        return "`indexOf()` replaceable by `contains()`";
    }

    public String getDescription() {
        return "Checking if a value is included in a `String` or `List` using `indexOf(value)>-1` or `indexOf(value)>=0` can be replaced with `contains(value)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2692");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_INDEX_MATCHER), new UsesMethod(LIST_INDEX_MATCHER)}), (TreeVisitor)new IndexOfReplaceableByContainsVisitor());
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaTemplate stringContains = JavaTemplate.builder((String)"#{any(java.lang.String)}.contains(#{any(java.lang.String)})").build();
        private final JavaTemplate listContains = JavaTemplate.builder((String)"#{any(java.util.List)}.contains(#{any(java.lang.Object)})").build();

        private IndexOfReplaceableByContainsVisitor() {
        }

        public J visitBinary(J.Binary binary, ExecutionContext ctx) {
            J j = super.visitBinary(binary, (Object)ctx);
            J.Binary asBinary = (J.Binary)j;
            if (asBinary.getLeft() instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)asBinary.getLeft();
                if ((STRING_INDEX_MATCHER.matches((MethodCall)mi) || mi.getSelect() != null && LIST_INDEX_MATCHER.matches((MethodCall)mi)) && asBinary.getRight() instanceof J.Literal) {
                    boolean isGreaterThanOrEqualToZero;
                    String valueSource = ((J.Literal)asBinary.getRight()).getValueSource();
                    boolean isGreaterThanNegativeOne = asBinary.getOperator() == J.Binary.Type.GreaterThan && "-1".equals(valueSource);
                    boolean bl = isGreaterThanOrEqualToZero = asBinary.getOperator() == J.Binary.Type.GreaterThanOrEqual && "0".equals(valueSource);
                    if (isGreaterThanNegativeOne || isGreaterThanOrEqualToZero) {
                        Cursor cursor = new Cursor(this.updateCursor((Tree)asBinary), (Object)asBinary.getLeft());
                        j = (STRING_INDEX_MATCHER.matches((MethodCall)mi) ? this.stringContains : this.listContains).apply(cursor, mi.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)}).withPrefix(asBinary.getPrefix());
                    }
                }
            }
            return j;
        }
    }
}

