/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.EqualsAvoidsNullVisitor;

public class EqualsAvoidsNull
extends Recipe {
    public String getDisplayName() {
        return "Equals avoids null";
    }

    public String getDescription() {
        return "Checks that any combination of String literals is on the left side of an `equals()` comparison. Also checks for String literals assigned to some field (such as `someString.equals(anotherString = \"text\"))`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1132");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EqualsAvoidsNullFromCompilationUnitStyle();
    }

    private static class EqualsAvoidsNullFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EqualsAvoidsNullFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                EqualsAvoidsNullStyle style = (EqualsAvoidsNullStyle)cu.getStyle(EqualsAvoidsNullStyle.class);
                if (style == null) {
                    style = Checkstyle.equalsAvoidsNull();
                }
                return (J)new EqualsAvoidsNullVisitor(style).visitNonNull((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

