/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.NeedBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;

public class NeedBraces
extends Recipe {
    public String getDisplayName() {
        return "Fix missing braces";
    }

    public String getDescription() {
        return "Adds missing braces around code such as single-line `if`, `for`, `while`, and `do-while` block bodies.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S121");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NeedBracesVisitor();
    }

    private static class NeedBracesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        NeedBracesStyle needBracesStyle;

        private NeedBracesVisitor() {
        }

        private <T extends Statement> J.Block buildBlock(Statement owner, T element) {
            J j = (J)this.getCursor().getParentTreeCursor().getValue();
            Space end = Space.EMPTY;
            if (j instanceof J.Block) {
                Space trailingSpace;
                J.Block block = (J.Block)j;
                List statements = block.getStatements();
                int i = statements.indexOf(owner);
                boolean last = i == statements.size() - 1;
                Space space = trailingSpace = last ? block.getEnd() : ((Statement)statements.get(i + 1)).getPrefix();
                if (!trailingSpace.getComments().isEmpty() && trailingSpace.getWhitespace().indexOf(10) == -1) {
                    end = trailingSpace;
                    ((List)this.getCursor().getParentTreeCursor().computeMessageIfAbsent("replaced", k -> new ArrayList())).add(i);
                }
            }
            return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)false), element instanceof J.Empty ? Collections.emptyList() : Collections.singletonList(JRightPadded.build(element)), end);
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                this.needBracesStyle = cu.getStyle(NeedBracesStyle.class) == null ? Checkstyle.needBracesStyle() : (NeedBracesStyle)cu.getStyle(NeedBracesStyle.class);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J.Block bl = super.visitBlock(block, (Object)ctx);
            List indexes = (List)this.getCursor().pollMessage("replaced");
            if (indexes != null) {
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    boolean last;
                    int index = (Integer)iterator.next();
                    boolean bl2 = last = index == bl.getPadding().getStatements().size() - 1;
                    if (!last) {
                        bl = bl.withStatements(ListUtils.map((List)bl.getStatements(), (i, stmt) -> {
                            if (i == index + 1) {
                                return (Statement)stmt.withPrefix(Space.EMPTY);
                            }
                            return stmt;
                        }));
                        continue;
                    }
                    bl = bl.withEnd(bl.getEnd().withComments(Collections.emptyList()));
                }
                bl = (J.Block)this.maybeAutoFormat((J)block, (J)bl, ctx);
            }
            return bl;
        }

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            if (this.usedAsExpression()) {
                return iff;
            }
            J.If elem = super.visitIf(iff, (Object)ctx);
            boolean hasAllowableBodyType = elem.getThenPart() instanceof J.Block;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock((Statement)elem, elem.getThenPart());
                elem = (J.If)this.maybeAutoFormat((J)elem, (J)elem.withThenPart((Statement)b), ctx);
            }
            return elem;
        }

        private boolean usedAsExpression() {
            return this.getCursor().getParentOrThrow().getValue() instanceof K.StatementExpression;
        }

        public J.If.Else visitElse(J.If.Else else_, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.If.Else elem = super.visitElse(else_, (Object)ctx);
            boolean bl = hasAllowableBodyType = elem.getBody() instanceof J.Block || elem.getBody() instanceof J.If;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock((Statement)this.getCursor().getParentTreeCursor().getValue(), elem.getBody());
                elem = (J.If.Else)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.WhileLoop elem = super.visitWhileLoop(whileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.DoWhileLoop elem = super.visitDoWhileLoop(doWhileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.ForLoop elem = super.visitForLoop(forLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock((Statement)elem, elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }
    }
}

